﻿---
title: FortiGate Super Admin Account Creation
description: This rule detects the creation of an administrator account on a FortiGate device. Administrator account creation on these devices should be infrequent...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/persistence_fortigate_super_admin_account_creation
products:
  - Elastic Security
---

# FortiGate Super Admin Account Creation
This rule detects the creation of an administrator account on a FortiGate device. Administrator account creation on
these devices should be infrequent and tightly controlled. In the FG-IR-26-060 campaign, threat actors created
super_admin accounts immediately after gaining initial access via FortiCloud SSO bypass to establish persistence.
**Rule type**: eql
**Rule indices**:
- logs-fortinet_fortigate.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.fortiguard.com/psirt/FG-IR-26-060](https://www.fortiguard.com/psirt/FG-IR-26-060)](https://www.fortiguard.com/psirt/FG-IR-26-060)
- [[https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)
- [[https://www.elastic.co/docs/reference/integrations/fortinet_fortigate](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)
- [[https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)

**Tags**:
- Use Case: Threat Detection
- Tactic: Persistence
- Resources: Investigation Guide
- Domain: Network
- Domain: Identity
- Data Source: Fortinet
- Data Source: Fortinet FortiGate

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating FortiGate Super Admin Account Creation

This alert indicates that an administrator account was created on a FortiGate device. Administrator creation events on these devices are generally rare and should be closely scrutinized, as they are a key persistence mechanism used in the FG-IR-26-060 campaign.
In the observed campaign, threat actors created multiple super_admin accounts (audit, backup, support, itadmin, secadmin, remoteadmin) within seconds of initial access to ensure persistent control even if individual accounts are discovered and removed.

### Possible investigation steps

- Review `fortinet.firewall.cfgobj` for the name of the newly created account and examine `fortinet.firewall.cfgattr` to determine the access profile assigned to the account (especially super_admin).
- Review `source.user.name` to determine which account performed the creation and `fortinet.firewall.ui` for the source interface and IP address. Verify whether this administrator is authorized to provision accounts.
- Check whether a login event (especially via SSO) occurred shortly before the account creation. Analyze the timing between events.
- Check `observer.name` to identify the FortiGate device and run `get system admin` to get the current administrator list. Check other FortiGate devices in the fleet for the same account name.


### False positive analysis

- Authorized provisioning of a new administrator account through an approved change management process.
- Initial device setup where administrator accounts are created as part of deployment.
- Migration or device replacement scenarios where accounts are replicated from another device.


### Response and remediation

- If unauthorized, delete the administrator account immediately and audit the creating account for compromise.
- Treat the device configuration as compromised and restore from a known-clean backup.
- Check all FortiGate devices for similar account creation and upgrade FortiOS to a patched version.
- If the activity is expected, document the provisioning activity and the business justification.


## Rule Query

```eql
any where event.dataset == "fortinet_fortigate.log" and
    event.code == "0100044547" and
    fortinet.firewall.cfgpath == "system.admin" and
    fortinet.firewall.action == "Add" and
    fortinet.firewall.cfgattr like~ "*accprofile[super_admin]*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create Account
- Id: T1136
- Reference URL: [[https://attack.mitre.org/techniques/T1136/](https://attack.mitre.org/techniques/T1136/)](https://attack.mitre.org/techniques/T1136/)
- Sub Technique:
  - Name: Local Account
- Id: T1136.001
- Reference URL: [[https://attack.mitre.org/techniques/T1136/001/](https://attack.mitre.org/techniques/T1136/001/)](https://attack.mitre.org/techniques/T1136/001/)