﻿---
title: FortiGate SSO Login Followed by Administrator Account Creation
description: This rule detects a FortiCloud SSO login followed by administrator account creation on the same FortiGate device within 15 minutes. This sequence is a...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/persistence_fortigate_sso_login_followed_by_admin_creation
products:
  - Elastic Security
---

# FortiGate SSO Login Followed by Administrator Account Creation
This rule detects a FortiCloud SSO login followed by administrator account creation on the same FortiGate device
within 15 minutes. This sequence is a high-confidence indicator of the FG-IR-26-060 attack pattern, where threat
actors authenticate via SAML-based SSO bypass and immediately create local administrator accounts for persistence.
**Rule type**: eql
**Rule indices**:
- logs-fortinet_fortigate.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 10m
**Searches indices from**: `now-30m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.fortiguard.com/psirt/FG-IR-26-060](https://www.fortiguard.com/psirt/FG-IR-26-060)](https://www.fortiguard.com/psirt/FG-IR-26-060)
- [[https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)
- [[https://www.elastic.co/docs/reference/integrations/fortinet_fortigate](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)
- [[https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)

**Tags**:
- Use Case: Threat Detection
- Tactic: Persistence
- Resources: Investigation Guide
- Domain: Network
- Domain: Identity
- Data Source: Fortinet
- Data Source: Fortinet FortiGate

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating FortiGate SSO Login Followed by Administrator Account Creation

This alert indicates that a FortiCloud SSO login was followed by an administrator account creation event on the same FortiGate device within 15 minutes. This two-event sequence is the core attack pattern observed in the FG-IR-26-060 campaign.
The attack flow is: authenticate via FortiCloud SSO using a crafted SAML assertion, then immediately create local administrator accounts to maintain access even after the SSO vulnerability is patched.

### Possible investigation steps

- Review the SSO login event for the FortiCloud account used and the source IP. Determine whether the SSO account belongs to the organization.
- Check the admin creation event for the names of accounts created and the access profiles assigned (especially super_admin).
- Assess the timing between events. In the observed campaign, admin creation occurs within seconds of SSO login. A tight time correlation is a strong indicator of compromise.
- Review `observer.name` to identify the targeted device and verify whether FortiCloud SSO is intentionally enabled. Run `get system admin` to list all current administrator accounts.
- Check whether the same SSO account or source IP targeted other devices. Look for configuration exports, firewall policy changes, or VPN modifications following the admin creation.


### False positive analysis

- An authorized administrator logging in via FortiCloud SSO and creating a new admin account as part of normal operations.
- Initial device onboarding where SSO login and account setup occur in the same session.


### Response and remediation

- If unauthorized, delete all administrator accounts created during the session and disable FortiCloud SSO immediately.
- Restore configuration from a known-clean backup and rotate all credentials including LDAP/AD accounts connected to the device.
- Upgrade FortiOS to a patched version and engage incident response for the affected device and any downstream systems.
- If the activity is expected, document the administrative session and verify it was authorized. Consider creating accounts through a separate session to avoid triggering this correlation.


## Rule Query

```eql
sequence by observer.name with maxspan=15m
  [authentication where event.dataset == "fortinet_fortigate.log" and
    event.action == "login" and event.outcome == "success" and
    (fortinet.firewall.method == "sso" or fortinet.firewall.ui like~ "sso*")]
  [any where event.dataset == "fortinet_fortigate.log" and
    event.code == "0100044547" and
    fortinet.firewall.cfgpath == "system.admin" and
    fortinet.firewall.action == "Add"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create Account
- Id: T1136
- Reference URL: [[https://attack.mitre.org/techniques/T1136/](https://attack.mitre.org/techniques/T1136/)](https://attack.mitre.org/techniques/T1136/)
- Sub Technique:
  - Name: Local Account
- Id: T1136.001
- Reference URL: [[https://attack.mitre.org/techniques/T1136/001/](https://attack.mitre.org/techniques/T1136/001/)](https://attack.mitre.org/techniques/T1136/001/)