﻿---
title: Abnormally Large DNS Response
description: Specially crafted DNS requests can manipulate a known overflow vulnerability in some Windows DNS servers, resulting in Remote Code Execution (RCE) or...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/lateral_movement_dns_server_overflow
products:
  - Elastic Security
---

# Abnormally Large DNS Response
Specially crafted DNS requests can manipulate a known overflow vulnerability in some Windows DNS servers, resulting in
Remote Code Execution (RCE) or a Denial of Service (DoS) from crashing the service.
**Rule type**: query
**Rule indices**:
- packetbeat-*
- filebeat-*
- logs-network_traffic.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://research.checkpoint.com/2020/resolving-your-way-into-domain-admin-exploiting-a-17-year-old-bug-in-windows-dns-servers/](https://research.checkpoint.com/2020/resolving-your-way-into-domain-admin-exploiting-a-17-year-old-bug-in-windows-dns-servers/)](https://research.checkpoint.com/2020/resolving-your-way-into-domain-admin-exploiting-a-17-year-old-bug-in-windows-dns-servers/)
- [[https://msrc-blog.microsoft.com/2020/07/14/july-2020-security-update-cve-2020-1350-vulnerability-in-windows-domain-name-system-dns-server/](https://msrc-blog.microsoft.com/2020/07/14/july-2020-security-update-cve-2020-1350-vulnerability-in-windows-domain-name-system-dns-server/)](https://msrc-blog.microsoft.com/2020/07/14/july-2020-security-update-cve-2020-1350-vulnerability-in-windows-domain-name-system-dns-server/)
- [[https://github.com/maxpl0it/CVE-2020-1350-DoS](https://github.com/maxpl0it/CVE-2020-1350-DoS)](https://github.com/maxpl0it/CVE-2020-1350-DoS)
- [[https://www.elastic.co/security-labs/detection-rules-for-sigred-vulnerability](https://www.elastic.co/security-labs/detection-rules-for-sigred-vulnerability)](https://www.elastic.co/security-labs/detection-rules-for-sigred-vulnerability)

**Tags**:
- Use Case: Threat Detection
- Tactic: Lateral Movement
- Resources: Investigation Guide
- Use Case: Vulnerability

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Abnormally Large DNS Response

Detection alerts from this rule indicate possible anomalous activity around large byte DNS responses from a Windows DNS server. This detection rule was created based on activity represented in exploitation of vulnerability (CVE-2020-1350) also known as [SigRed](https://www.elastic.co/blog/detection-rules-for-sigred-vulnerability) during July 2020.

#### Possible investigation steps

- This specific rule is sourced from network log activity such as DNS or network level data. It's important to validate the source of the incoming traffic and determine if this activity has been observed previously within an environment.
- Activity can be further investigated and validated by reviewing any associated Intrusion Detection Signatures (IDS) alerts.
- Further examination can include a review of the `dns.question_type` network fieldset with a protocol analyzer, such as Zeek, Packetbeat, or Suricata, for `SIG` or `RRSIG` data.
- Validate the patch level and OS of the targeted DNS server to validate the observed activity was not large-scale internet vulnerability scanning.
- Validate that the source of the network activity was not from an authorized vulnerability scan or compromise assessment.


#### False positive analysis

- Based on this rule, which looks for a threshold of 60k bytes, it is possible for activity to be generated under 65k bytes and related to legitimate behavior. In packet capture files received by the [SANS Internet Storm Center](https://isc.sans.edu/forums/diary/PATCH+NOW+SIGRed+CVE20201350+Microsoft+DNS+Server+Vulnerability/26356/), byte responses were all observed as greater than 65k bytes.
- This activity can be triggered by compliance/vulnerability scanning or compromise assessment; it's important to determine the source of the activity and potentially allowlist the source host.


### Related rules

- Unusual Child Process of dns.exe - 8c37dc0e-e3ac-4c97-8aa0-cf6a9122de45
- Unusual File Modification by dns.exe - c7ce36c0-32ff-4f9a-bfc2-dcb242bf99f9


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Ensure that you have deployed the latest Microsoft [Security Update](https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1350) (Monthly Rollup or Security Only) and restarted the patched machines. If unable to patch immediately, Microsoft [released](https://support.microsoft.com/en-us/help/4569509/windows-dns-server-remote-code-execution-vulnerability) a registry-based workaround that doesn’t require a restart. This can be used as a temporary solution before the patch is applied.
- Maintain backups of your critical systems to aid in quick recovery.
- Perform routine vulnerability scans of your systems, monitor [CISA advisories](https://us-cert.cisa.gov/ncas/current-activity) and patch identified vulnerabilities.
- If you observe a true positive, implement a remediation plan and monitor host-based artifacts for additional post-exploitation behavior.


## Rule Query

```kuery
(event.dataset: network_traffic.dns or (event.category: (network or network_traffic) and destination.port: 53)) and
  (event.dataset:zeek.dns or type:dns or event.type:connection) and network.bytes > 60000
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Exploitation of Remote Services
- Id: T1210
- Reference URL: [[https://attack.mitre.org/techniques/T1210/](https://attack.mitre.org/techniques/T1210/)](https://attack.mitre.org/techniques/T1210/)