﻿---
title: RPC (Remote Procedure Call) to the Internet
description: This rule detects network events that may indicate the use of RPC traffic to the Internet. RPC is commonly used by system administrators to remotely control...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_rpc_remote_procedure_call_to_the_internet
products:
  - Elastic Security
---

# RPC (Remote Procedure Call) to the Internet
This rule detects network events that may indicate the use of RPC traffic to the Internet. RPC is commonly used by
system administrators to remotely control a system for maintenance or to use shared resources. It should almost never be
directly exposed to the Internet, as it is frequently targeted and exploited by threat actors as an initial access or
backdoor vector.
**Rule type**: query
**Rule indices**:
- packetbeat-*
- auditbeat-*
- filebeat-*
- logs-network_traffic.*
- logs-panw.panos*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml](https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml)](https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml)

**Tags**:
- Tactic: Initial Access
- Domain: Endpoint
- Use Case: Threat Detection
- Data Source: PAN-OS
- Resources: Investigation Guide

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating RPC (Remote Procedure Call) to the Internet

RPC enables remote management and resource sharing across networks, crucial for system administration. However, when exposed to the Internet, it becomes a target for attackers seeking initial access or backdoor entry. The detection rule identifies suspicious RPC traffic from internal IPs to external networks, flagging potential exploitation attempts by monitoring specific ports and IP ranges.

### Possible investigation steps

- Review the source IP address from the alert to identify the internal system initiating the RPC traffic. Check if this IP belongs to a known or authorized device within the network.
- Examine the destination IP address to determine if it is a known or suspicious external entity. Use threat intelligence sources to assess if the IP has been associated with malicious activity.
- Analyze the network traffic logs for the specific event.dataset values (network_traffic.flow or zeek.dce_rpc) to gather more context about the nature and volume of the RPC traffic.
- Investigate the destination port, specifically port 135, to confirm if the traffic is indeed RPC-related and assess if there are any legitimate reasons for this communication.
- Check for any recent changes or anomalies in the network configuration or system settings of the source IP that might explain the unexpected RPC traffic.
- Correlate this alert with other security events or logs to identify any patterns or additional indicators of compromise that might suggest a broader attack campaign.


### False positive analysis

- Internal testing environments may generate RPC traffic to external IPs for legitimate purposes. Identify and document these environments, then create exceptions in the detection rule to prevent unnecessary alerts.
- Cloud-based services or applications that require RPC communication for integration or management might trigger false positives. Review these services and whitelist their IP addresses if they are verified as non-threatening.
- VPN or remote access solutions that use RPC for secure connections can be mistaken for suspicious activity. Ensure that the IP ranges of these solutions are excluded from the rule to avoid false alerts.
- Automated backup or synchronization tools that use RPC to communicate with external servers could be flagged. Verify these tools and add their destination IPs to an exception list if they are part of routine operations.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Conduct a thorough analysis of the affected system to identify any unauthorized changes or installed backdoors, focusing on processes and services related to RPC.
- Revoke any compromised credentials and enforce a password reset for all accounts that may have been accessed or used during the incident.
- Apply necessary patches and updates to the affected system and any other systems with similar vulnerabilities to mitigate the risk of exploitation.
- Monitor network traffic for any signs of lateral movement or additional suspicious activity, particularly focusing on RPC-related traffic.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement enhanced logging and monitoring for RPC traffic to detect and respond to similar threats more effectively in the future.


## Rule Query

```kuery
(event.dataset: network_traffic.flow or (event.category: (network or network_traffic))) and
  network.transport:tcp and (destination.port:135 or event.dataset:zeek.dce_rpc) and
  source.ip:(
    10.0.0.0/8 or
    172.16.0.0/12 or
    192.168.0.0/16
  ) and
  not destination.ip:(
    10.0.0.0/8 or
    127.0.0.0/8 or
    169.254.0.0/16 or
    172.16.0.0/12 or
    192.0.0.0/24 or
    192.0.0.0/29 or
    192.0.0.8/32 or
    192.0.0.9/32 or
    192.0.0.10/32 or
    192.0.0.170/32 or
    192.0.0.171/32 or
    192.0.2.0/24 or
    192.31.196.0/24 or
    192.52.193.0/24 or
    192.168.0.0/16 or
    192.88.99.0/24 or
    224.0.0.0/4 or
    100.64.0.0/10 or
    192.175.48.0/24 or
    198.18.0.0/15 or
    198.51.100.0/24 or
    203.0.113.0/24 or
    240.0.0.0/4 or
    "::1" or
    "FE80::/10" or
    "FF00::/8"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)