﻿---
title: React2Shell Network Security Alert
description: This rule identifies network security alerts related to CVE-2025-55182 exploitation attempts from different network security integrations. CVE-2025-55182...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_react_server_rce_network_alerts
products:
  - Elastic Security
---

# React2Shell Network Security Alert
This rule identifies network security alerts related to CVE-2025-55182 exploitation attempts from different network security
integrations. CVE-2025-55182 is a critical remote code execution vulnerability in React Server Components (RSC) Flight protocol.
The vulnerability allows attackers to execute arbitrary code on the server by sending specially crafted deserialization payloads
that exploit prototype chain traversal to access the Function constructor.
**Rule type**: query
**Rule indices**:
- logs-panw.panos*
- logs-cisco_ftd.*
- logs-fortinet_fortigate.*
- logs-suricata.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.wiz.io/blog/critical-vulnerability-in-react-cve-2025-55182](https://www.wiz.io/blog/critical-vulnerability-in-react-cve-2025-55182)](https://www.wiz.io/blog/critical-vulnerability-in-react-cve-2025-55182)
- [[https://github.com/assetnote/react2shell-scanner](https://github.com/assetnote/react2shell-scanner)](https://github.com/assetnote/react2shell-scanner)
- [[https://slcyber.io/research-center/high-fidelity-detection-mechanism-for-rsc-next-js-rce-cve-2025-55182-cve-2025-66478/](https://slcyber.io/research-center/high-fidelity-detection-mechanism-for-rsc-next-js-rce-cve-2025-55182-cve-2025-66478/)](https://slcyber.io/research-center/high-fidelity-detection-mechanism-for-rsc-next-js-rce-cve-2025-55182-cve-2025-66478/)
- [[https://github.com/msanft/CVE-2025-55182](https://github.com/msanft/CVE-2025-55182)](https://github.com/msanft/CVE-2025-55182)

**Tags**:
- Domain: Network
- Domain: Application
- Domain: Web
- Use Case: Threat Detection
- Use Case: Vulnerability
- Tactic: Initial Access
- Tactic: Execution
- Data Source: PAN-OS
- Data Source: Fortinet
- Data Source: Suricata
- Data Source: Cisco FTD
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating React2Shell Network Security Alert

This rule detects exploitation attempts targeting CVE-2025-55182, a critical remote code execution vulnerability in React's Flight protocol used by Next.js and other RSC implementations. The vulnerability stems from insecure prototype chain traversal in the Flight deserializer, allowing attackers to access `__proto__`, `constructor`, and ultimately the `Function` constructor to execute arbitrary code.

### Possible investigation steps

- Examine the full HTTP request body to identify the specific attack payload and command being executed.
- Check the response body for `E{"digest":"..."}` patterns which contain command output from successful exploitation.
- Identify the target application and verify if it runs vulnerable React (< 19.1.0) or Next.js (< 15.3.2) versions.
- Review the source IP for other reconnaissance or exploitation attempts against web applications.
- Check for the `Next-Action` header which is required for the exploit to work.
- Correlate with process execution logs to identify if child processes (e.g., shell commands) were spawned by the Node.js process.


### False positive analysis

- Legitimate React Server Components traffic will NOT contain `__proto__`, `constructor:constructor`, or code execution patterns.
- Security scanning tools like react2shell-scanner may trigger this rule during authorized penetration testing.
- The combination of prototype pollution patterns with RSC-specific syntax is highly indicative of malicious activity.


### Response and remediation

- Immediately update affected applications: React >= 19.1.0, Next.js >= 15.3.2.
- Block the source IP at the WAF/reverse proxy if exploitation is confirmed.
- If HTTP 500 or 303 responses with `digest` output were observed, assume successful code execution and investigate for compromise.
- Review server logs for evidence of command execution (file creation, network connections, process spawning).
- Implement WAF rules to block requests containing `__proto__` or `constructor:constructor` in POST bodies.


## Rule Query

```kuery
(event.dataset:"cisco_ftd.log" and message:"SERVER-WEBAPP React Server Components remote code execution attempt") or
(event.dataset:"fortinet_fortigate.log" and message:"applications3: React.Server.Components.react-flight.Remote.Code.Execution") or
(event.dataset:"panw.panos" and event.action:"exploit_detected" and event.original :*React*Server*) or
(event.dataset:("suricata_corelight" or "suricata.eve") and rule.name:*CVE-2025-55182*)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: JavaScript
- Id: T1059.007
- Reference URL: [[https://attack.mitre.org/techniques/T1059/007/](https://attack.mitre.org/techniques/T1059/007/)](https://attack.mitre.org/techniques/T1059/007/)