﻿---
title: FortiGate FortiCloud SSO Login from Unusual Source
description: This rule detects the first successful FortiCloud SSO login from a previously unseen source IP address to a FortiGate device within the last 5 days. FortiCloud...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_fortigate_sso_login_from_unusual_source
products:
  - Elastic Security
---

# FortiGate FortiCloud SSO Login from Unusual Source
This rule detects the first successful FortiCloud SSO login from a previously unseen source IP address to a FortiGate
device within the last 5 days. FortiCloud SSO logins from new source IPs may indicate exploitation of SAML-based
authentication bypass vulnerabilities such as CVE-2026-24858, where crafted SAML assertions allow unauthorized access to
FortiGate devices registered to other accounts. Environments that regularly use FortiCloud SSO will only alert on new
source IPs not seen in the lookback window.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-7205m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.fortiguard.com/psirt/FG-IR-26-060](https://www.fortiguard.com/psirt/FG-IR-26-060)](https://www.fortiguard.com/psirt/FG-IR-26-060)
- [[https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)
- [[https://www.elastic.co/docs/reference/integrations/fortinet_fortigate](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)
- [[https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)

**Tags**:
- Use Case: Threat Detection
- Tactic: Initial Access
- Resources: Investigation Guide
- Domain: Network
- Domain: Identity
- Data Source: Fortinet
- Data Source: Fortinet FortiGate

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating FortiGate FortiCloud SSO Login from Unusual Source

This alert indicates that a FortiCloud SSO login was observed from a source IP address not previously seen authenticating via SSO in the last 5 days. This is a high-value signal because it filters out routine SSO access from known management IPs and only fires on novel source addresses.
CVE-2026-24858 (FG-IR-26-060) allows attackers with a FortiCloud account and a registered device to craft SAML assertions that authenticate them as administrators on other FortiGate devices when FortiCloud SSO is enabled. This vulnerability has been actively exploited in the wild.

### Possible investigation steps

- Check `source.ip` against known corporate management networks, VPN egress points, and jump hosts. Investigate the IP's ASN and geolocation, as attacker IPs have been observed from The Constant Company LLC, BL Networks, Kaopu Cloud HK Limited, and Cloudflare-protected ranges.
- Determine whether this IP has been seen in any other authentication context across the environment.
- Check `Esql.user_values` for the SSO account name (typically an email address) and verify the account belongs to the organization. Compare against known attacker email IOCs: cloud-noc@mail.io, cloud-init@mail.io, heltaylor.12@tutamail.com, support@openmail.pro.
- Check `Esql.observer_name_values` to identify which FortiGate device was accessed and confirm whether FortiCloud SSO is intentionally enabled on the device.
- Look for local administrator account creation, configuration exports, firewall policy changes, or VPN user/group creation immediately following the SSO login. The observed attack pattern involves rogue admin creation within seconds of login.


### False positive analysis

- Administrators connecting from a new office location, hotel, or home network for the first time may trigger this alert.
- FortiCloud SSO access after IP address changes such as ISP rotation or VPN egress changes can appear as a new source IP.
- First login after FortiCloud SSO is initially enabled on a device will fire since no historical SSO logins exist.


### Response and remediation

- If the activity is unauthorized, disable FortiCloud SSO immediately using `config system global` > `set admin-forticloud-sso-login disable`.
- Audit all administrator accounts for unauthorized additions and review and restore configuration from a known-clean backup.
- Rotate all credentials including any LDAP/AD accounts connected to the device.
- Upgrade FortiOS to a patched version.
- If the activity is expected, document the new source IP and consider adding an exception if it represents a new management location.


## Rule Query

```esql
FROM logs-fortinet_fortigate.* metadata _id, _version, _index

| WHERE event.dataset == "fortinet_fortigate.log" and
        event.category == "authentication" and event.action == "login" and
        event.outcome == "success" and
        (fortinet.firewall.method == "sso" or fortinet.firewall.ui like "sso*") and
        source.ip is not null
| STATS Esql.logon_count = COUNT(*),
        Esql.first_time_seen = MIN(@timestamp),
        Esql.user_values = VALUES(source.user.name),
        Esql.observer_name_values = VALUES(observer.name),
        Esql.message_values = VALUES(message) BY source.ip

// first time seen is within 6m of the rule execution time and for the last 5d of events history
| EVAL Esql.recent = DATE_DIFF("minute", Esql.first_time_seen, now())
| WHERE Esql.recent <= 6 AND Esql.logon_count == 1

// move dynamic fields to ECS equivalent for rule exceptions
| EVAL source.user.name = MV_FIRST(Esql.user_values)

| KEEP source.ip, source.user.name, Esql.*
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)