﻿---
title: FortiGate Overly Permissive Firewall Policy Created
description: This rule detects the creation or modification of a FortiGate firewall policy that permits all sources, all destinations, and all services. An overly...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/defense_evasion_fortigate_overly_permissive_firewall_policy
products:
  - Elastic Security
---

# FortiGate Overly Permissive Firewall Policy Created
This rule detects the creation or modification of a FortiGate firewall policy that permits all sources, all
destinations, and all services. An overly permissive policy effectively bypasses all firewall protections. Threat actors
exploiting CVE-2026-24858 have been observed creating such policies to allow unrestricted traffic flow through
compromised FortiGate devices.
**Rule type**: eql
**Rule indices**:
- logs-fortinet_fortigate.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 5m
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.fortiguard.com/psirt/FG-IR-26-060](https://www.fortiguard.com/psirt/FG-IR-26-060)](https://www.fortiguard.com/psirt/FG-IR-26-060)
- [[https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)
- [[https://www.elastic.co/docs/reference/integrations/fortinet_fortigate](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)
- [[https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)

**Tags**:
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Domain: Network
- Data Source: Fortinet
- Data Source: Fortinet FortiGate

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating FortiGate Overly Permissive Firewall Policy Created

This alert indicates that a firewall policy was created or modified on a FortiGate device with source address `all`, destination address `all`, and service `ALL`. This configuration effectively disables firewall enforcement for traffic matching the policy.
In the FG-IR-26-060 campaign, threat actors created these permissive policies to ensure their traffic could traverse the firewall without restriction.

### Possible investigation steps

- Review `source.user.name` to determine which account created or modified the policy and `fortinet.firewall.ui` for the source interface and IP address. Verify whether this administrator is authorized to make firewall policy changes.
- Examine `fortinet.firewall.cfgattr` for the full policy configuration including interfaces, NAT settings, and scheduling. Check `fortinet.firewall.cfgobj` for the affected policy ID and determine whether the policy is positioned to intercept traffic (policy ordering matters).
- Look for administrator account creation, SSO login events, or configuration exports preceding this change. Determine whether the administrator account itself was recently created.
- Identify which interfaces the policy applies to (srcintf/dstintf in cfgattr) and determine whether the policy enables inbound, outbound, or both directions of unrestricted traffic.


### False positive analysis

- Temporary troubleshooting policies created during network diagnostics (should be time-limited and removed).
- Initial device setup or lab environments where broad policies are intentionally configured.
- Migration or cutover scenarios where temporary permissive rules are needed.


### Response and remediation

- If unauthorized, immediately delete the permissive firewall policy and audit the administrator account that created it for compromise.
- Review all other firewall policies for unauthorized modifications and check for other indicators of compromise on the device (rogue admins, VPN users).
- Restore the policy configuration from a known-clean backup.
- If the activity is expected, document the business justification and ensure a removal timeline is defined. Replace with specific source/destination/service rules as soon as possible.


## Rule Query

```eql
any where event.dataset == "fortinet_fortigate.log" and
    event.code == "0100044547" and
    fortinet.firewall.cfgpath == "firewall.policy" and
    fortinet.firewall.action in ("Add", "Edit") and
    fortinet.firewall.cfgattr like~ "*srcaddr[all]*" and
    fortinet.firewall.cfgattr like~ "*dstaddr[all]*" and
    fortinet.firewall.cfgattr like~ "*service[all]*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify System Firewall
- Id: T1562.004
- Reference URL: [[https://attack.mitre.org/techniques/T1562/004/](https://attack.mitre.org/techniques/T1562/004/)](https://attack.mitre.org/techniques/T1562/004/)