﻿---
title: VNC (Virtual Network Computing) from the Internet
description: This rule detects network events that may indicate the use of VNC traffic from the Internet. VNC is commonly used by system administrators to remotely...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_vnc_virtual_network_computing_from_the_internet
products:
  - Elastic Security
---

# VNC (Virtual Network Computing) from the Internet
This rule detects network events that may indicate the use of VNC traffic from the Internet. VNC is commonly used by
system administrators to remotely control a system for maintenance or to use shared resources. It should almost never be
directly exposed to the Internet, as it is frequently targeted and exploited by threat actors as an initial access or
backdoor vector.
**Rule type**: query
**Rule indices**:
- packetbeat-*
- auditbeat-*
- filebeat-*
- logs-network_traffic.*
- logs-panw.panos*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml](https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml)](https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml)

**Tags**:
- Tactic: Command and Control
- Domain: Endpoint
- Use Case: Threat Detection
- Data Source: PAN-OS
- Resources: Investigation Guide

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating VNC (Virtual Network Computing) from the Internet

VNC allows remote control of systems, facilitating maintenance and resource sharing. However, when exposed to the Internet, it becomes a target for attackers seeking unauthorized access. Adversaries exploit VNC for initial access or as a backdoor. The detection rule identifies suspicious VNC traffic by monitoring specific TCP ports and filtering out trusted IP ranges, flagging potential threats for further investigation.

### Possible investigation steps

- Review the source IP address of the alert to determine if it is from an untrusted or suspicious location, as the rule filters out known trusted IP ranges.
- Check the destination IP address to confirm it belongs to an internal network (10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16) and verify if the system is authorized to receive VNC traffic.
- Analyze the network traffic logs for the specified TCP ports (5800-5810) to identify any unusual patterns or repeated access attempts that could indicate malicious activity.
- Investigate the context of the event by correlating it with other security alerts or logs to determine if there are signs of a broader attack or compromise.
- Assess the risk and impact of the potential threat by evaluating the criticality of the affected system and any sensitive data it may contain.


### False positive analysis

- Internal testing or maintenance activities may trigger the rule if VNC is used for legitimate purposes within a controlled environment. To manage this, create exceptions for known internal IP addresses that frequently use VNC for authorized tasks.
- Automated systems or scripts that utilize VNC for routine operations might be flagged. Identify these systems and exclude their IP addresses from the rule to prevent unnecessary alerts.
- Remote workers using VPNs that route traffic through public IPs could be mistakenly identified as threats. Ensure that VPN IP ranges are included in the trusted IP list to avoid false positives.
- Misconfigured network devices that inadvertently expose VNC ports to the Internet can cause alerts. Regularly audit network configurations to ensure VNC ports are not exposed and adjust the rule to exclude known safe configurations.
- Third-party service providers accessing systems via VNC for support purposes might be flagged. Establish a list of trusted IPs for these providers and update the rule to exclude them from detection.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Terminate any active VNC sessions originating from untrusted IP addresses to cut off potential attacker access.
- Conduct a thorough review of system logs and network traffic to identify any unauthorized changes or data access that may have occurred during the VNC session.
- Reset credentials for any accounts that were accessed or could have been compromised during the unauthorized VNC session.
- Apply security patches and updates to the VNC software and any other potentially vulnerable applications on the affected system.
- Implement network segmentation to ensure that VNC services are only accessible from trusted internal networks and not exposed to the Internet.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems may be affected.


## Rule Query

```kuery
(event.dataset: network_traffic.flow or (event.category: (network or network_traffic))) and
  network.transport:tcp and destination.port >= 5800 and destination.port <= 5810 and
  not source.ip:(
    10.0.0.0/8 or
    127.0.0.0/8 or
    169.254.0.0/16 or
    172.16.0.0/12 or
    192.0.0.0/24 or
    192.0.0.0/29 or
    192.0.0.8/32 or
    192.0.0.9/32 or
    192.0.0.10/32 or
    192.0.0.170/32 or
    192.0.0.171/32 or
    192.0.2.0/24 or
    192.31.196.0/24 or
    192.52.193.0/24 or
    192.168.0.0/16 or
    192.88.99.0/24 or
    224.0.0.0/4 or
    100.64.0.0/10 or
    192.175.48.0/24 or
    198.18.0.0/15 or
    198.51.100.0/24 or
    203.0.113.0/24 or
    240.0.0.0/4 or
    "::1" or
    "FE80::/10" or
    "FF00::/8"
  ) and
  destination.ip:(
    10.0.0.0/8 or
    172.16.0.0/12 or
    192.168.0.0/16
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Remote Access Tools
- Id: T1219
- Reference URL: [[https://attack.mitre.org/techniques/T1219/](https://attack.mitre.org/techniques/T1219/)](https://attack.mitre.org/techniques/T1219/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)