﻿---
title: Possible FIN7 DGA Command and Control Behavior
description: This rule detects a known command and control pattern in network events. The FIN7 threat group is known to use this command and control technique, while...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_fin7_c2_behavior
products:
  - Elastic Security
---

# Possible FIN7 DGA Command and Control Behavior
This rule detects a known command and control pattern in network events. The FIN7 threat group is known to use this
command and control technique, while maintaining persistence in their target's network.
**Rule type**: query
**Rule indices**:
- packetbeat-*
- auditbeat-*
- filebeat-*
- logs-network_traffic.*
- logs-panw.panos*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.fireeye.com/blog/threat-research/2018/08/fin7-pursuing-an-enigmatic-and-evasive-global-criminal-operation.html](https://www.fireeye.com/blog/threat-research/2018/08/fin7-pursuing-an-enigmatic-and-evasive-global-criminal-operation.html)](https://www.fireeye.com/blog/threat-research/2018/08/fin7-pursuing-an-enigmatic-and-evasive-global-criminal-operation.html)

**Tags**:
- Use Case: Threat Detection
- Tactic: Command and Control
- Domain: Endpoint
- Data Source: PAN-OS
- Resources: Investigation Guide

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis

In the event this rule identifies benign domains in your environment, the `destination.domain` field in the rule can be modified to include those domains. Example: `...AND NOT destination.domain:(zoom.us OR benign.domain1 OR benign.domain2)`.

## Rule Query

```json
(event.dataset: (network_traffic.tls OR network_traffic.http) OR
    (event.category: (network OR network_traffic) AND type: (tls OR http) AND network.transport: tcp)) AND
destination.domain:/[a-zA-Z]{4,5}\.(pw|us|club|info|site|top)/ AND NOT destination.domain:zoom.us
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)
- Technique:
  - Name: Dynamic Resolution
- Id: T1568
- Reference URL: [[https://attack.mitre.org/techniques/T1568/](https://attack.mitre.org/techniques/T1568/)](https://attack.mitre.org/techniques/T1568/)
- Sub Technique:
  - Name: Domain Generation Algorithms
- Id: T1568.002
- Reference URL: [[https://attack.mitre.org/techniques/T1568/002/](https://attack.mitre.org/techniques/T1568/002/)](https://attack.mitre.org/techniques/T1568/002/)