﻿---
title: FortiGate Configuration File Downloaded
description: This rule detects the download of a FortiGate device configuration file. Configuration exports contain sensitive data including administrator password...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/collection_fortigate_config_download
products:
  - Elastic Security
---

# FortiGate Configuration File Downloaded
This rule detects the download of a FortiGate device configuration file. Configuration exports contain sensitive data
including administrator password hashes, LDAP bind credentials, VPN pre-shared keys, routing tables, and firewall
policies. Threat actors exploiting CVE-2026-24858 have been observed exporting the full device configuration
immediately after gaining access to harvest credentials and map the internal network.
**Rule type**: eql
**Rule indices**:
- logs-fortinet_fortigate.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.fortiguard.com/psirt/FG-IR-26-060](https://www.fortiguard.com/psirt/FG-IR-26-060)](https://www.fortiguard.com/psirt/FG-IR-26-060)
- [[https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)](https://www.fortinet.com/blog/psirt-blogs/analysis-of-sso-abuse-on-fortios)
- [[https://www.elastic.co/docs/reference/integrations/fortinet_fortigate](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)
- [[https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)](https://www.cisa.gov/news-events/alerts/2026/01/28/fortinet-releases-guidance-address-ongoing-exploitation-authentication-bypass-vulnerability-cve-2026)

**Tags**:
- Use Case: Threat Detection
- Tactic: Collection
- Resources: Investigation Guide
- Domain: Network
- Data Source: Fortinet
- Data Source: Fortinet FortiGate

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating FortiGate Configuration File Downloaded

This alert indicates that a FortiGate device configuration file was downloaded. Configuration files contain highly sensitive information including administrator credentials, LDAP/RADIUS secrets, VPN pre-shared keys, certificate private keys, and the complete network topology.
In the FG-IR-26-060 campaign, threat actors exported the full device configuration shortly after creating rogue administrator accounts, using the harvested credentials for lateral movement and to maintain access through alternative channels.

### Possible investigation steps

- Review `source.user.name` to determine which account initiated the download and `fortinet.firewall.ui` for the source interface and IP address (e.g., GUI, CLI, or API). Verify whether this administrator is authorized to export device configurations.
- Check whether a scheduled backup process or configuration management tool performed this action. Look for preceding SSO login events or administrator account creation events on the same device and determine whether the downloading account was recently created.
- Check `observer.name` to identify which device had its configuration exported and search for configuration download events across other FortiGate devices in the fleet.
- Check for firewall policy changes, VPN configuration modifications, or additional admin account creation after the download. Determine whether any credentials from the configuration have been used for lateral movement.


### False positive analysis

- Scheduled configuration backups performed by FortiManager, Ansible, or other automation tools.
- Administrator-initiated backups during planned maintenance or before firmware upgrades.
- Configuration audits or compliance checks that require config export.


### Response and remediation

- If unauthorized, treat all credentials in the configuration as compromised. Rotate all passwords, pre-shared keys, LDAP bind credentials, and RADIUS secrets contained in the configuration.
- Revoke and reissue any certificates whose private keys were included in the export.
- Audit the administrator account that performed the download for compromise and check for other indicators of compromise on the device (rogue admins, policy changes).
- If the activity is expected, document the backup activity and verify it was performed through an authorized process. Ensure configuration backups are stored securely with appropriate access controls.


## Rule Query

```eql
any where event.dataset == "fortinet_fortigate.log" and
    event.code == "0100032095" and
    fortinet.firewall.action == "download"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Data from Configuration Repository
- Id: T1602
- Reference URL: [[https://attack.mitre.org/techniques/T1602/](https://attack.mitre.org/techniques/T1602/)](https://attack.mitre.org/techniques/T1602/)
- Sub Technique:
  - Name: Network Device Configuration Dump
- Id: T1602.002
- Reference URL: [[https://attack.mitre.org/techniques/T1602/002/](https://attack.mitre.org/techniques/T1602/002/)](https://attack.mitre.org/techniques/T1602/002/)