﻿---
title: Network Traffic to Rare Destination Country
description: A machine learning job detected a rare destination country name in the network logs. This can be due to initial access, persistence, command-and-control,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_rare_destination_country
products:
  - Elastic Security
---

# Network Traffic to Rare Destination Country
A machine learning job detected a rare destination country name in the network logs. This can be due to initial access,
persistence, command-and-control, or exfiltration activity. For example, when a user clicks on a link in a phishing
email or opens a malicious document, a request may be sent to download and run a payload from a server in a country
which does not normally appear in network traffic or business work-flows. Malware instances and persistence mechanisms
may communicate with command-and-control (C2) infrastructure in their country of origin, which may be an unusual
destination country for the source network.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-30m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)

**Tags**:
- Use Case: Threat Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Resources: Investigation Guide

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires the installation of associated Machine Learning jobs, as well as data coming in from one of the following integrations:
- Elastic Defend
- Network Packet Capture


### Anomaly Detection Setup

Once the rule is enabled, the associated Machine Learning job will start automatically. You can view the Machine Learning job linked under the "Definition" panel of the detection rule. If the job does not start due to an error, the issue must be resolved for the job to commence successfully. For more details on setting up anomaly detection jobs, refer to the [helper guide](https://www.elastic.co/guide/en/kibana/current/xpack-ml-anomalies.html).

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration to your system:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


### Network Packet Capture Integration Setup

The Network Packet Capture integration sniffs network packets on a host and dissects known protocols. Monitoring the network traffic is critical to gaining observability and securing your environment — ensuring high levels of performance and security. The Network Packet Capture integration captures the network traffic between your application servers, decodes common application layer protocols and records the interesting fields for each transaction.

#### The following steps should be executed in order to add the Elastic Agent System integration "network_traffic" to your system:

- Go to the Kibana home page and click “Add integrations”.
- In the query bar, search for “Network Packet Capture” and select the integration to see more details about it.
- Click “Add Network Packet Capture”.
- Configure the integration name and optionally add a description.
- Review optional and advanced settings accordingly.
- Add the newly installed “network_traffic” to an existing or a new agent policy, and deploy the agent on your system from which network log files are desirable.
- Click “Save and Continue”.
- For more details on the integration refer to the [helper guide](https://docs.elastic.co/integrations/network_traffic).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Network Traffic to Rare Destination Country

Machine learning models analyze network logs to identify traffic to uncommon destination countries, which may indicate malicious activities like unauthorized access or data exfiltration. Adversaries exploit this by directing traffic to servers in atypical locations, often linked to command-and-control operations. The detection rule flags such anomalies, aiding in early threat identification and response.

### Possible investigation steps

- Review the network logs to identify the specific destination country flagged as rare and assess its historical presence in the network traffic.
- Analyze the source IP addresses and user accounts associated with the flagged traffic to determine if they are legitimate or potentially compromised.
- Investigate the nature of the traffic, such as the protocols and ports used, to identify any unusual patterns or connections to known malicious infrastructure.
- Check for any recent phishing attempts or suspicious emails that may have led to the initiation of this traffic, focusing on links or attachments that could have been used to download malicious payloads.
- Correlate the flagged traffic with any other security alerts or incidents to identify potential patterns or coordinated attacks involving the rare destination country.
- Consult threat intelligence sources to determine if the destination country or specific IP addresses are associated with known threat actors or command-and-control servers.


### False positive analysis

- Legitimate business communications with partners or clients in rare destination countries may trigger alerts. Users should review and whitelist these known entities to prevent future false positives.
- Routine software updates or patches from international vendors might be flagged. Identify and exclude these update servers from the detection rule to avoid unnecessary alerts.
- Employees traveling abroad and accessing company resources can generate alerts. Implement a process to temporarily whitelist these destinations based on travel schedules.
- Cloud services with global data centers may route traffic through uncommon countries. Verify the service's IP ranges and exclude them if they are part of normal operations.
- Research or market expansion activities targeting new regions might cause alerts. Document and exclude these activities if they align with business objectives.


### Response and remediation

- Isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Conduct a thorough scan of the isolated system for malware or unauthorized software, focusing on identifying any command-and-control (C2) communication channels.
- Block network traffic to and from the identified rare destination country at the firewall or proxy level to prevent further communication with potential malicious servers.
- Review and analyze logs from the affected system and network devices to identify any additional indicators of compromise or related suspicious activities.
- If malware is detected, remove it using appropriate tools and techniques, ensuring that all persistence mechanisms are eradicated.
- Restore the affected system from a clean backup if necessary, ensuring that all security patches and updates are applied.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Phishing
- Id: T1566
- Reference URL: [[https://attack.mitre.org/techniques/T1566/](https://attack.mitre.org/techniques/T1566/)](https://attack.mitre.org/techniques/T1566/)
- Sub Technique:
  - Name: Spearphishing Attachment
- Id: T1566.001
- Reference URL: [[https://attack.mitre.org/techniques/T1566/001/](https://attack.mitre.org/techniques/T1566/001/)](https://attack.mitre.org/techniques/T1566/001/)
- Sub Technique:
  - Name: Spearphishing Link
- Id: T1566.002
- Reference URL: [[https://attack.mitre.org/techniques/T1566/002/](https://attack.mitre.org/techniques/T1566/002/)](https://attack.mitre.org/techniques/T1566/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)
- Technique:
  - Name: Ingress Tool Transfer
- Id: T1105
- Reference URL: [[https://attack.mitre.org/techniques/T1105/](https://attack.mitre.org/techniques/T1105/)](https://attack.mitre.org/techniques/T1105/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Exfiltration
- Id: TA0010
- Reference URL: [[https://attack.mitre.org/tactics/TA0010/](https://attack.mitre.org/tactics/TA0010/)](https://attack.mitre.org/tactics/TA0010/)
- Technique:
  - Name: Exfiltration Over C2 Channel
- Id: T1041
- Reference URL: [[https://attack.mitre.org/techniques/T1041/](https://attack.mitre.org/techniques/T1041/)](https://attack.mitre.org/techniques/T1041/)
- Technique:
  - Name: Exfiltration Over Alternative Protocol
- Id: T1048
- Reference URL: [[https://attack.mitre.org/techniques/T1048/](https://attack.mitre.org/techniques/T1048/)](https://attack.mitre.org/techniques/T1048/)