﻿---
title: Spike in Firewall Denies
description: A machine learning job detected an unusually large spike in network traffic that was denied by network access control lists (ACLs) or firewall rules...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_high_count_network_denies
products:
  - Elastic Security
---

# Spike in Firewall Denies
A machine learning job detected an unusually large spike in network traffic that was denied by network access control
lists (ACLs) or firewall rules. Such a burst of denied traffic is usually caused by either 1) a mis-configured
application or firewall or 2) suspicious or malicious activity. Unsuccessful attempts at network transit, in order to
connect to command-and-control (C2), or engage in data exfiltration, may produce a burst of failed connections. This
could also be due to unusually large amounts of reconnaissance or enumeration traffic. Denial-of-service attacks or
traffic floods may also produce such a surge in traffic.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-30m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)

**Tags**:
- Use Case: Threat Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Resources: Investigation Guide

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires the installation of associated Machine Learning jobs, as well as data coming in from one of the following integrations:
- Elastic Defend
- Network Packet Capture


### Anomaly Detection Setup

Once the rule is enabled, the associated Machine Learning job will start automatically. You can view the Machine Learning job linked under the "Definition" panel of the detection rule. If the job does not start due to an error, the issue must be resolved for the job to commence successfully. For more details on setting up anomaly detection jobs, refer to the [helper guide](https://www.elastic.co/guide/en/kibana/current/xpack-ml-anomalies.html).

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration to your system:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


### Network Packet Capture Integration Setup

The Network Packet Capture integration sniffs network packets on a host and dissects known protocols. Monitoring the network traffic is critical to gaining observability and securing your environment — ensuring high levels of performance and security. The Network Packet Capture integration captures the network traffic between your application servers, decodes common application layer protocols and records the interesting fields for each transaction.

#### The following steps should be executed in order to add the Elastic Agent System integration "network_traffic" to your system:

- Go to the Kibana home page and click “Add integrations”.
- In the query bar, search for “Network Packet Capture” and select the integration to see more details about it.
- Click “Add Network Packet Capture”.
- Configure the integration name and optionally add a description.
- Review optional and advanced settings accordingly.
- Add the newly installed “network_traffic” to an existing or a new agent policy, and deploy the agent on your system from which network log files are desirable.
- Click “Save and Continue”.
- For more details on the integration refer to the [helper guide](https://docs.elastic.co/integrations/network_traffic).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Spike in Firewall Denies

Firewalls and ACLs are critical in controlling network traffic, blocking unauthorized access. Adversaries may exploit misconfigurations or launch attacks like reconnaissance or denial-of-service to overwhelm these defenses. The 'Spike in Firewall Denies' detection rule leverages machine learning to identify unusual surges in denied traffic, signaling potential misconfigurations or malicious activities.

### Possible investigation steps

- Review the time frame and source IP addresses associated with the spike in denied traffic to identify any patterns or anomalies.
- Check the firewall and ACL logs for any recent changes or misconfigurations that could have led to the increase in denied traffic.
- Investigate the destination IP addresses and ports targeted by the denied traffic to determine if they are associated with known malicious activity or if they are legitimate services.
- Analyze the volume and frequency of the denied requests to assess whether they align with typical denial-of-service attack patterns or reconnaissance activities.
- Correlate the denied traffic with other security alerts or logs to identify any related suspicious activities or potential indicators of compromise within the network.


### False positive analysis

- Routine network scans by security tools or IT teams may trigger spikes in denied traffic. Regularly review and whitelist known IP addresses or tools to prevent these from being flagged.
- Misconfigured applications that frequently attempt unauthorized access can cause false positives. Identify and correct these configurations to reduce unnecessary alerts.
- Legitimate but high-volume business applications might generate traffic patterns similar to reconnaissance activities. Monitor and document these applications, and create exceptions for their traffic patterns.
- Scheduled maintenance or updates can lead to temporary spikes in denied traffic. Coordinate with IT teams to anticipate these events and adjust monitoring rules accordingly.
- Internal network changes, such as new device deployments or network architecture updates, might cause unexpected traffic patterns. Ensure these changes are communicated and accounted for in the firewall rules to minimize false positives.


### Response and remediation

- Immediately isolate affected systems or segments of the network to prevent further unauthorized access or potential spread of malicious activity.
- Analyze the denied traffic logs to identify the source IP addresses and block them at the firewall or ACL level to prevent further attempts.
- Review and correct any misconfigurations in firewall rules or ACLs that may have contributed to the spike in denied traffic.
- Conduct a thorough investigation to determine if the spike is related to a denial-of-service attack and, if confirmed, engage with your internet service provider (ISP) for additional support and mitigation strategies.
- If malicious activity is suspected, escalate the incident to the security operations center (SOC) or incident response team for further analysis and response.
- Implement additional monitoring and alerting for similar patterns of denied traffic to enhance early detection of potential threats.
- Document the incident, including actions taken and lessons learned, to improve future response efforts and update incident response plans accordingly.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Exfiltration
- Id: TA0010
- Reference URL: [[https://attack.mitre.org/tactics/TA0010/](https://attack.mitre.org/tactics/TA0010/)](https://attack.mitre.org/tactics/TA0010/)
- Technique:
  - Name: Exfiltration Over C2 Channel
- Id: T1041
- Reference URL: [[https://attack.mitre.org/techniques/T1041/](https://attack.mitre.org/techniques/T1041/)](https://attack.mitre.org/techniques/T1041/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Network Service Discovery
- Id: T1046
- Reference URL: [[https://attack.mitre.org/techniques/T1046/](https://attack.mitre.org/techniques/T1046/)](https://attack.mitre.org/techniques/T1046/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Reconnaissance
- Id: TA0043
- Reference URL: [[https://attack.mitre.org/tactics/TA0043/](https://attack.mitre.org/tactics/TA0043/)](https://attack.mitre.org/tactics/TA0043/)
- Technique:
  - Name: Gather Victim Network Information
- Id: T1590
- Reference URL: [[https://attack.mitre.org/techniques/T1590/](https://attack.mitre.org/techniques/T1590/)](https://attack.mitre.org/techniques/T1590/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Network Denial of Service
- Id: T1498
- Reference URL: [[https://attack.mitre.org/techniques/T1498/](https://attack.mitre.org/techniques/T1498/)](https://attack.mitre.org/techniques/T1498/)
- Technique:
  - Name: Endpoint Denial of Service
- Id: T1499
- Reference URL: [[https://attack.mitre.org/techniques/T1499/](https://attack.mitre.org/techniques/T1499/)](https://attack.mitre.org/techniques/T1499/)