﻿---
title: Unusual Windows Process Calling the Metadata Service
description: Looks for anomalous access to the metadata service by an unusual process. The metadata service may be targeted in order to harvest credentials or user...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/credential_access_ml_windows_anomalous_metadata_process
products:
  - Elastic Security
---

# Unusual Windows Process Calling the Metadata Service
Looks for anomalous access to the metadata service by an unusual process. The metadata service may be targeted in order
to harvest credentials or user data scripts containing secrets.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-45m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 209
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires the installation of associated Machine Learning jobs, as well as data coming in from one of the following integrations:
- Elastic Defend
- Windows


### Anomaly Detection Setup

Once the rule is enabled, the associated Machine Learning job will start automatically. You can view the Machine Learning job linked under the "Definition" panel of the detection rule. If the job does not start due to an error, the issue must be resolved for the job to commence successfully. For more details on setting up anomaly detection jobs, refer to the [helper guide](https://www.elastic.co/guide/en/kibana/current/xpack-ml-anomalies.html).

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration to your system:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


### Windows Integration Setup

The Windows integration allows you to monitor the Windows OS, services, applications, and more.

#### The following steps should be executed in order to add the Elastic Agent System integration "windows" to your system:

- Go to the Kibana home page and click “Add integrations”.
- In the query bar, search for “Windows” and select the integration to see more details about it.
- Click “Add Windows”.
- Configure the integration name and optionally add a description.
- Review optional and advanced settings accordingly.
- Add the newly installed “windows” to an existing or a new agent policy, and deploy the agent on your system from which windows log files are desirable.
- Click “Save and Continue”.
- For more details on the integration refer to the [helper guide](https://docs.elastic.co/integrations/windows).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Unusual Windows Process Calling the Metadata Service

In cloud environments, the metadata service provides essential instance information, including credentials and configuration data. Adversaries may exploit this by using atypical Windows processes to access the service, aiming to extract sensitive information. The detection rule leverages machine learning to identify anomalies in process behavior, flagging potential credential access attempts by unusual processes.

### Possible investigation steps

- Review the process name and command line arguments associated with the alert to identify any unusual or suspicious activity.
- Check the parent process of the flagged process to understand the context of how it was initiated and assess if it aligns with expected behavior.
- Investigate the user account under which the process was executed to determine if it has legitimate access to the metadata service or if it has been compromised.
- Analyze network logs to identify any outbound connections to the metadata service from the flagged process, noting any unusual patterns or destinations.
- Cross-reference the process and user activity with recent changes or deployments in the environment to rule out false positives related to legitimate administrative actions.
- Consult threat intelligence sources to see if the process or command line arguments have been associated with known malicious activity or campaigns.


### False positive analysis

- Routine system updates or maintenance scripts may trigger the rule. Review the process details and verify if they align with scheduled maintenance activities. If confirmed, consider adding these processes to an exception list.
- Legitimate software or security tools that access the metadata service for configuration purposes might be flagged. Identify these tools and create exceptions for their known processes to prevent future alerts.
- Automated backup or monitoring solutions that interact with the metadata service could be misidentified as threats. Validate these processes and exclude them if they are part of authorized operations.
- Custom scripts developed in-house for cloud management tasks may access the metadata service. Ensure these scripts are documented and, if safe, add them to the list of exceptions to reduce false positives.


### Response and remediation

- Isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Terminate the unusual process accessing the metadata service to stop any ongoing credential harvesting attempts.
- Conduct a thorough review of the system's event logs and process history to identify any additional indicators of compromise or related malicious activity.
- Change all credentials that may have been exposed or accessed through the metadata service to mitigate the risk of unauthorized access.
- Implement network segmentation to limit access to the metadata service, ensuring only authorized processes and users can interact with it.
- Escalate the incident to the security operations center (SOC) for further analysis and to determine if the threat is part of a larger attack campaign.
- Update and enhance endpoint detection and response (EDR) solutions to improve monitoring and alerting for similar anomalous process behaviors in the future.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Unsecured Credentials
- Id: T1552
- Reference URL: [[https://attack.mitre.org/techniques/T1552/](https://attack.mitre.org/techniques/T1552/)](https://attack.mitre.org/techniques/T1552/)
- Sub Technique:
  - Name: Cloud Instance Metadata API
- Id: T1552.005
- Reference URL: [[https://attack.mitre.org/techniques/T1552/005/](https://attack.mitre.org/techniques/T1552/005/)](https://attack.mitre.org/techniques/T1552/005/)