﻿---
title: User Added to the Admin Group
description: Identifies users being added to the admin group. This could be an indication of privilege escalation activity. Rule type: eql Rule indices: logs-jamf_protect*...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/privilege_escalation_user_added_to_admin_group
products:
  - Elastic Security
---

# User Added to the Admin Group
Identifies users being added to the admin group. This could be an indication of privilege
escalation activity.
**Rule type**: eql
**Rule indices**:
- logs-jamf_protect*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.loobins.io/binaries/dscl/](https://www.loobins.io/binaries/dscl/)](https://www.loobins.io/binaries/dscl/)
- [[https://managingosx.wordpress.com/2010/01/14/add-a-user-to-the-admin-group-via-command-line-3-0/](https://managingosx.wordpress.com/2010/01/14/add-a-user-to-the-admin-group-via-command-line-3-0/)](https://managingosx.wordpress.com/2010/01/14/add-a-user-to-the-admin-group-via-command-line-3-0/)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Jamf Protect
- Resources: Investigation Guide

**Version**: 4
**Rule authors**:
- Thijs Xhaflaire

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Jamf Protect.

### Jamf Protect Integration Setup

Jamf Protect is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events incoming events and send data to the Elastic.

#### Prerequisite Requirements:

- Fleet is required for Jamf Protect.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Jamf Protect integration:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Jamf Protect" and select the integration to see more details about it.
- Click "Add Jamf Protect".
- Configure the integration name.
- Click "Save and Continue".


## Investigation guide


## Triage and analysis

To thoroughly investigate the actions that occurred **after a user was elevated to administrator**, it's essential to conduct a search on the Timeline. This allows you to review and understand the sequence of events that followed the elevation, helping to identify any potentially malicious or unauthorized activities that might have taken place. **Analyzing these actions is crucial for maintaining security and ensuring that the elevation was not exploited for harmful purposes.**> **Note**:
This investigation guide uses the [Investigate Markdown Plugin](https://www.elastic.co/guide/en/security/current/interactive-investigation-guides.html) introduced in Elastic Stack version 8.8.0. Older Elastic Stack versions will display unrendered Markdown in this guide.
**Consider reviewing these actions:**
- Have persistency items been added?
- Is any software installed after elevation?
- Were any additional users created after elevation?

$investigate_0
$investigate_1
$investigate_2

## Rule Query

```eql
configuration where host.os.type == "macos" and event.type == "change" and
  event.action == "od_group_add" and group.name:"admin"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Local Accounts
- Id: T1078.003
- Reference URL: [[https://attack.mitre.org/techniques/T1078/003/](https://attack.mitre.org/techniques/T1078/003/)](https://attack.mitre.org/techniques/T1078/003/)