﻿---
title: Privilege Escalation via Root Crontab File Modification
description: Identifies modifications to the root crontab file. Adversaries may overwrite this file to gain code execution with root privileges by exploiting privileged...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/privilege_escalation_root_crontab_filemod
products:
  - Elastic Security
---

# Privilege Escalation via Root Crontab File Modification
Identifies modifications to the root crontab file. Adversaries may overwrite this file to gain code execution with root
privileges by exploiting privileged file write or move related vulnerabilities.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://phoenhex.re/2017-06-09/pwn2own-diskarbitrationd-privesc](https://phoenhex.re/2017-06-09/pwn2own-diskarbitrationd-privesc)](https://phoenhex.re/2017-06-09/pwn2own-diskarbitrationd-privesc)
- [[https://www.exploit-db.com/exploits/42146](https://www.exploit-db.com/exploits/42146)](https://www.exploit-db.com/exploits/42146)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 110
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a macOS System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, for MacOS it is recommended to select "Traditional Endpoints".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Privilege Escalation via Root Crontab File Modification

Crontab files in macOS are used to schedule tasks, often requiring elevated privileges for execution. Adversaries exploit this by modifying the root crontab file, enabling unauthorized code execution with root access. The detection rule identifies suspicious modifications to this file, excluding legitimate crontab processes, to flag potential privilege escalation attempts.

### Possible investigation steps

- Review the alert details to confirm the file path involved is /private/var/at/tabs/root, as this is the specific file path targeted by the rule.
- Examine the process that modified the root crontab file by checking the process executable path. Ensure it is not /usr/bin/crontab, which is excluded as a legitimate process.
- Investigate the user account associated with the process that made the modification to determine if it has legitimate access or if it might be compromised.
- Check for any recent changes or anomalies in user account activity or permissions that could indicate unauthorized access or privilege escalation attempts.
- Correlate this event with other security alerts or logs from the same host to identify any patterns or additional suspicious activities that might suggest a broader attack campaign.
- Assess the risk and impact of the modification by determining if any unauthorized or malicious tasks have been scheduled in the crontab file.


### False positive analysis

- System maintenance tasks or updates may modify the root crontab file. To handle these, users can create exceptions for known maintenance processes that are verified as safe.
- Administrative scripts that require scheduled tasks might trigger this rule. Users should document and exclude these scripts if they are part of regular, authorized operations.
- Backup or monitoring software that interacts with crontab files could cause false positives. Verify these applications and exclude their processes if they are legitimate and necessary for system operations.
- Custom automation tools used by IT departments might modify crontab files. Ensure these tools are reviewed and whitelisted if they are part of approved workflows.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or execution of malicious tasks.
- Review the modified root crontab file to identify any unauthorized or suspicious entries and remove them to stop any malicious scheduled tasks.
- Conduct a thorough investigation to determine how the crontab file was modified, focusing on identifying any exploited vulnerabilities or unauthorized access points.
- Reset credentials and review permissions for any accounts that may have been compromised or used in the attack to prevent further unauthorized access.
- Apply security patches and updates to the operating system and any vulnerable applications to close exploited vulnerabilities.
- Monitor the system and network for any signs of continued unauthorized activity or attempts to modify crontab files, using enhanced logging and alerting mechanisms.
- Escalate the incident to the appropriate internal security team or external cybersecurity experts if the threat persists or if there is evidence of a broader compromise.


## Rule Query

```eql
file where host.os.type == "macos" and event.action == "modification" and
 file.path like "/private/var/at/tabs/root" and 
 not process.executable like "/usr/bin/crontab"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Scheduled Task/Job
- Id: T1053
- Reference URL: [[https://attack.mitre.org/techniques/T1053/](https://attack.mitre.org/techniques/T1053/)](https://attack.mitre.org/techniques/T1053/)
- Sub Technique:
  - Name: Cron
- Id: T1053.003
- Reference URL: [[https://attack.mitre.org/techniques/T1053/003/](https://attack.mitre.org/techniques/T1053/003/)](https://attack.mitre.org/techniques/T1053/003/)