﻿---
title: Execution with Explicit Credentials via Scripting
description: Identifies execution of the security_authtrampoline process via a scripting interpreter. This occurs when programs use AuthorizationExecute-WithPrivileges...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/privilege_escalation_explicit_creds_via_scripting
products:
  - Elastic Security
---

# Execution with Explicit Credentials via Scripting
Identifies execution of the security_authtrampoline process via a scripting interpreter. This occurs when programs use
AuthorizationExecute-WithPrivileges from the Security.framework to run another program with root privileges. It should
not be run by itself, as this is a sign of execution with explicit logon credentials.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://objectivebythesea.com/v2/talks/OBTS_v2_Thomas.pdf](https://objectivebythesea.com/v2/talks/OBTS_v2_Thomas.pdf)](https://objectivebythesea.com/v2/talks/OBTS_v2_Thomas.pdf)
- [[https://www.manpagez.com/man/8/security_authtrampoline/](https://www.manpagez.com/man/8/security_authtrampoline/)](https://www.manpagez.com/man/8/security_authtrampoline/)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Privilege Escalation
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 110
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a macOS System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, for MacOS it is recommended to select "Traditional Endpoints".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Execution with Explicit Credentials via Scripting

In macOS environments, the `security_authtrampoline` process is used to execute programs with elevated privileges via scripting interpreters. Adversaries may exploit this by using explicit credentials to run unauthorized scripts, gaining root access. The detection rule identifies such activities by monitoring the initiation of `security_authtrampoline` through common scripting languages, flagging potential privilege escalation attempts.

### Possible investigation steps

- Review the process details to confirm the parent process name matches one of the specified scripting interpreters (e.g., osascript, bash, python) to verify the context of the alert.
- Examine the command line arguments of the security_authtrampoline process to identify the script or program being executed and assess its legitimacy.
- Investigate the user account associated with the process to determine if the credentials used are valid and expected for executing such scripts.
- Check the historical activity of the involved user account and associated processes to identify any patterns of unusual or unauthorized behavior.
- Correlate the alert with other security events or logs from the same host to identify any additional indicators of compromise or related suspicious activities.
- Assess the system for any signs of compromise or unauthorized changes, such as unexpected new files, altered configurations, or additional unauthorized processes running.


### False positive analysis

- Legitimate administrative tasks using scripting languages may trigger this rule. Users should review the context of the script execution to determine if it aligns with expected administrative activities.
- Automated scripts or scheduled tasks that require elevated privileges might be flagged. Consider creating exceptions for known scripts by specifying their hash or path in the monitoring system.
- Development or testing environments where developers frequently use scripting languages to test applications with elevated privileges can cause false positives. Implement a policy to exclude these environments from the rule or adjust the risk score to reflect the lower threat level.
- Security tools or software updates that use scripting interpreters to perform legitimate actions with elevated privileges may be mistakenly identified. Verify the source and purpose of such processes and whitelist them if they are deemed safe.
- User-initiated scripts for personal productivity that require elevated access could be misinterpreted as threats. Educate users on safe scripting practices and establish a process for them to report and document legitimate use cases for exclusion.


### Response and remediation

- Immediately isolate the affected macOS system from the network to prevent further unauthorized access or lateral movement.
- Terminate the `security_authtrampoline` process if it is still running to stop any ongoing unauthorized activities.
- Review and revoke any compromised credentials used in the execution of the unauthorized script to prevent further misuse.
- Conduct a thorough examination of the system for any additional unauthorized scripts or malware that may have been deployed using the compromised credentials.
- Restore the system from a known good backup if any unauthorized changes or persistent threats are detected.
- Implement stricter access controls and monitoring for the use of scripting interpreters and the `security_authtrampoline` process to prevent similar privilege escalation attempts.
- Escalate the incident to the security operations team for further investigation and to assess the potential impact on other systems within the network.


## Rule Query

```eql
process where host.os.type == "macos" and event.type in ("start", "process_started") and
 process.name == "security_authtrampoline" and
 process.parent.name like~ ("osascript", "com.apple.automator.runner", "sh", "bash", "dash", "zsh", "python*", "perl*", "php*", "ruby", "pwsh")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Technique:
  - Name: Abuse Elevation Control Mechanism
- Id: T1548
- Reference URL: [[https://attack.mitre.org/techniques/T1548/](https://attack.mitre.org/techniques/T1548/)](https://attack.mitre.org/techniques/T1548/)
- Sub Technique:
  - Name: Elevated Execution with Prompt
- Id: T1548.004
- Reference URL: [[https://attack.mitre.org/techniques/T1548/004/](https://attack.mitre.org/techniques/T1548/004/)](https://attack.mitre.org/techniques/T1548/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)