﻿---
title: Manual Loading of a Suspicious Chromium Extension
description: Detects the manual loading of a Chromium-based browser extension via command line arguments. This activity is suspicious and could indicate a threat actor...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_manual_chromium_extension_loading
products:
  - Elastic Security
---

# Manual Loading of a Suspicious Chromium Extension
Detects the manual loading of a Chromium-based browser extension via command line arguments. This activity
is suspicious and could indicate a threat actor loading a malicious extension to persist or collect browsing
secrets such as cookies and authentication tokens.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://cedowens.medium.com/remotely-dumping-chrome-cookies-revisited-b25343257209](https://cedowens.medium.com/remotely-dumping-chrome-cookies-revisited-b25343257209)](https://cedowens.medium.com/remotely-dumping-chrome-cookies-revisited-b25343257209)
- [[https://github.com/cedowens/Dump-Chrome-Cookies](https://github.com/cedowens/Dump-Chrome-Cookies)](https://github.com/cedowens/Dump-Chrome-Cookies)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Credential Access
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Manual Loading of a Suspicious Chromium Extension

Chromium-based browsers support loading extensions from local directories using the --load-extension command line flag, bypassing the normal extension store installation process. Threat actors abuse this capability to load malicious extensions that can steal cookies, capture session tokens, intercept form submissions, or inject content into web pages. Unlike store-installed extensions, manually loaded extensions don't undergo security review and can request arbitrary permissions. This detection rule identifies browsers launched with the --load-extension flag from suspicious parent processes.

### Possible investigation steps

- Examine the process.args containing --load-extension to identify the full path of the extension being loaded.
- Navigate to the extension directory and review the manifest.json to understand the permissions requested, including access to cookies, tabs, or web requests.
- Analyze the extension's JavaScript files for malicious functionality such as cookie exfiltration, form interception, or communication with external servers.
- Review the process.parent.executable to understand how the browser was launched with the malicious extension and trace back to the initial execution vector.
- Check for network connections made by the browser process to identify potential data exfiltration endpoints.
- Review browser profile data for evidence of credential theft or session hijacking.
- Search for the same extension path across other systems to identify potential lateral movement or widespread deployment.


### False positive analysis

- Cypress and other automated testing frameworks load extensions for browser automation. These are already excluded in the query.
- ChromeDriver used for Selenium testing loads extensions programmatically. These paths are excluded in the query.
- Developer debugging may require manual extension loading during active development. Verify with development teams if such activities are expected.
- Enterprise browser customization may deploy internal extensions via command line. Review with IT operations to document approved extensions.


### Response and remediation

- Immediately terminate the browser process to stop any ongoing malicious activity such as cookie theft or session hijacking.
- Remove the malicious extension directory from the filesystem to prevent future loading.
- Clear browser session data including cookies, cached credentials, and saved passwords for the affected browser profile.
- Review and revoke any sessions for sensitive web applications that were accessed while the extension was loaded.
- Investigate how the malicious extension was deployed and remediate the initial access vector.
- Block the malicious extension path or hash in endpoint security policies to prevent reloading.
- Reset passwords for web accounts that may have been compromised through the malicious extension.
- Check browser sync settings to ensure the malicious extension doesn't propagate to other devices.


## Rule Query

```eql
process where host.os.type == "macos" and event.action == "exec" and
  process.name in ("Google Chrome", "Brave Browser", "Microsoft Edge") and
  process.args like "--load-extension=/*" and
  not (process.args like "--load-extension=/Users/*/Library/Application Support/Cypress/*" and
       process.parent.executable like ("/Applications/Google Chrome.app/Contents/MacOS/Google Chrome",
                                        "/Users/*/Library/Caches/Cypress/*/Cypress.app/Contents/MacOS/Cypress")) and
  not process.parent.executable like ("/opt/homebrew/Caskroom/chromedriver/*/chromedriver",
                                    "/Applications/Cypress.app/Contents/MacOS/Cypress",
                                    "/usr/local/bin/chromedriver")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Software Extensions
- Id: T1176
- Reference URL: [[https://attack.mitre.org/techniques/T1176/](https://attack.mitre.org/techniques/T1176/)](https://attack.mitre.org/techniques/T1176/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Steal Web Session Cookie
- Id: T1539
- Reference URL: [[https://attack.mitre.org/techniques/T1539/](https://attack.mitre.org/techniques/T1539/)](https://attack.mitre.org/techniques/T1539/)