﻿---
title: Persistence via Docker Shortcut Modification
description: An adversary can establish persistence by modifying an existing macOS dock property list in order to execute a malicious application instead of the intended...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_docker_shortcuts_plist_modification
products:
  - Elastic Security
---

# Persistence via Docker Shortcut Modification
An adversary can establish persistence by modifying an existing macOS dock property list in order to execute a malicious
application instead of the intended one when invoked.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/specterops/presentations/raw/master/Leo%20Pitt/Hey_Im_Still_in_Here_Modern_macOS_Persistence_SO-CON2020.pdf](https://github.com/specterops/presentations/raw/master/Leo%20Pitt/Hey_Im_Still_in_Here_Modern_macOS_Persistence_SO-CON2020.pdf)](https://github.com/specterops/presentations/raw/master/Leo%20Pitt/Hey_Im_Still_in_Here_Modern_macOS_Persistence_SO-CON2020.pdf)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 111
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a macOS System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, for MacOS it is recommended to select "Traditional Endpoints".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Persistence via Docker Shortcut Modification

Docker shortcuts on macOS are managed through dock property lists, which define application launch behaviors. Adversaries may exploit this by altering these lists to redirect shortcuts to malicious applications, thus achieving persistence. The detection rule identifies unauthorized modifications to these property lists, excluding legitimate processes, to flag potential threats. This approach helps in pinpointing suspicious activities that could indicate persistence mechanisms being established by attackers.

### Possible investigation steps

- Review the alert details to identify the specific file path and process name involved in the modification of the com.apple.dock.plist file.
- Examine the process that triggered the alert by checking its parent process, command line arguments, and execution history to determine if it is associated with known malicious activity.
- Investigate the user account associated with the file modification to determine if there are any signs of compromise or unauthorized access.
- Check for any recent changes or anomalies in the user's environment, such as new applications installed or unexpected network connections, that could indicate further malicious activity.
- Correlate the event with other security alerts or logs from the same host to identify any patterns or additional indicators of compromise.
- If possible, restore the original com.apple.dock.plist file from a backup to ensure the system's integrity and prevent the execution of any malicious applications.


### False positive analysis

- Legitimate software updates or installations may modify the dock property list. Users can create exceptions for known update processes like software management tools to prevent false alerts.
- System maintenance tasks performed by macOS utilities might trigger the rule. Exclude processes such as cfprefsd and plutil, which are involved in regular system operations, to reduce noise.
- Custom scripts or automation tools that modify user preferences could be flagged. Identify and whitelist these scripts if they are part of routine administrative tasks.
- Security or IT management tools like Jamf or Kandji may interact with dock property lists. Ensure these tools are included in the exclusion list to avoid unnecessary alerts.
- User-initiated changes to dock settings can also be mistaken for malicious activity. Educate users on the implications of modifying dock settings and monitor for patterns that deviate from normal behavior.


### Response and remediation

- Immediately isolate the affected macOS system from the network to prevent further malicious activity or lateral movement.
- Terminate any suspicious processes identified as modifying the dock property list, especially those not matching legitimate process names or executables.
- Restore the original com.apple.dock.plist file from a known good backup to ensure the dock shortcuts are not redirecting to malicious applications.
- Conduct a thorough scan of the system using updated antivirus or endpoint detection tools to identify and remove any additional malicious software.
- Review and audit user accounts and permissions on the affected system to ensure no unauthorized access or privilege escalation has occurred.
- Implement monitoring for any future unauthorized modifications to dock property lists, ensuring alerts are configured for quick response.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems may be affected.


## Rule Query

```eql
file where host.os.type == "macos" and event.action == "modification" and
 file.path like "/Users/*/Library/Preferences/com.apple.dock.plist" and
 ((process.name like~ ("osascript", "python*", "sh", "bash", "zsh", "node") or Effective_process.name like~ ("osascript", "python*", "sh", "bash", "zsh", "node")) or
  (process.code_signature.exists == false or process.code_signature.trusted == false))
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create or Modify System Process
- Id: T1543
- Reference URL: [[https://attack.mitre.org/techniques/T1543/](https://attack.mitre.org/techniques/T1543/)](https://attack.mitre.org/techniques/T1543/)