﻿---
title: Curl Execution via Shell Profile
description: Detects when curl is executed via a shell profile upon login. This indicates a curl command was added to the user's shell profile (like .zshrc or .bashrc)...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_curl_execution_via_shell_profile
products:
  - Elastic Security
---

# Curl Execution via Shell Profile
Detects when curl is executed via a shell profile upon login. This indicates a curl command was added to the
user's shell profile (like .zshrc or .bashrc) and is executed automatically at login, which could be used for
persistence and payload delivery.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Command and Control
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Curl Execution via Shell Profile

Shell profile scripts (.zshrc, .bashrc, .bash_profile, .zprofile) execute automatically when users open new terminal sessions, making them valuable persistence mechanisms. Threat actors inject curl commands into these profiles to download and execute additional payloads each time the user opens a terminal, creating a reliable beacon mechanism that persists across system reboots. This detection rule identifies curl execution with download flags that originates directly from shell profile execution at login.

### Possible investigation steps

- Review the shell profile files (.zshrc, .bashrc, .bash_profile, .zprofile) for the affected user to identify the injected curl command and its destination URL.
- Analyze the process.args to determine the full curl command including output destination (-o, --output) and any other flags used.
- Investigate the destination URL in threat intelligence databases to determine if it is associated with known malicious infrastructure.
- Review the file modification timestamps of the shell profile files to determine when the malicious entry was added.
- Check browser history, email attachments, and download logs to understand how the attacker initially gained access to modify the profile.
- Examine the user.name associated with the modified profile to assess the scope of potential data access.
- Search for downloaded files on the system that may have been retrieved by the curl command and analyze their contents.


### False positive analysis

- Developers may add curl commands to shell profiles for convenience, such as fetching daily updates or checking API endpoints. Verify the URL destination and purpose with the user.
- Some shell customization frameworks and plugins use curl to update themselves on shell startup. Review common frameworks like Oh My Zsh for expected behavior.
- Enterprise tools may configure shell profiles for authentication or environment setup. Confirm with IT operations if such configurations are expected.
- Elastic infrastructure URLs are already excluded in the query to reduce noise from legitimate Elastic tooling.


### Response and remediation

- Remove the malicious curl command from the affected shell profile file immediately.
- Block the destination URL at the network perimeter to prevent payload delivery.
- Search for any files that were downloaded by the curl command and quarantine or remove them.
- Review user credentials and tokens that may have been exposed, as shell sessions often contain sensitive environment variables.
- Investigate how the shell profile was modified to identify the initial access vector.
- Check other user accounts on the system for similar shell profile modifications.
- Reset the user's shell profile from a known-good backup or template if available.
- Monitor for curl execution from shell profiles across the environment to identify additional compromised systems.


## Rule Query

```eql
sequence with maxspan=10s
  [process where host.os.type == "macos" and event.type == "start" and event.action == "exec" and
    process.name in ("bash", "zsh", "sh") and
    process.args in ("-zsh", "-sh", "-bash") and process.args_count == 1 and
    process.parent.name == "login"] by process.entity_id
  [process where host.os.type == "macos" and event.type == "start" and event.action == "exec" and
    process.name in ("curl", "nscurl") and
    process.args in ("-o", "--output", "--download", "-dl", "-dir", "--directory", "-F", "--form") and
    not process.args like ("https://upload.elastic.co*", "https://vault-ci-prod.elastic.dev", "https://artifacts.elastic.co*")] by process.parent.entity_id
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Event Triggered Execution
- Id: T1546
- Reference URL: [[https://attack.mitre.org/techniques/T1546/](https://attack.mitre.org/techniques/T1546/)](https://attack.mitre.org/techniques/T1546/)
- Sub Technique:
  - Name: Unix Shell Configuration Modification
- Id: T1546.004
- Reference URL: [[https://attack.mitre.org/techniques/T1546/004/](https://attack.mitre.org/techniques/T1546/004/)](https://attack.mitre.org/techniques/T1546/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Ingress Tool Transfer
- Id: T1105
- Reference URL: [[https://attack.mitre.org/techniques/T1105/](https://attack.mitre.org/techniques/T1105/)](https://attack.mitre.org/techniques/T1105/)