﻿---
title: Suspicious CronTab Creation or Modification
description: Identifies attempts to create or modify a crontab via a process that is not crontab (i.e python, osascript, etc.). This activity should not be highly...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_crontab_creation
products:
  - Elastic Security
---

# Suspicious CronTab Creation or Modification
Identifies attempts to create or modify a crontab via a process that is not crontab (i.e python, osascript, etc.). This
activity should not be highly prevalent and could indicate the use of cron as a persistence mechanism by a threat actor.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://taomm.org/PDFs/vol1/CH%200x02%20Persistence.pdf](https://taomm.org/PDFs/vol1/CH%200x02%20Persistence.pdf)](https://taomm.org/PDFs/vol1/CH%200x02%20Persistence.pdf)
- [[https://theevilbit.github.io/beyond/beyond_0004/](https://theevilbit.github.io/beyond/beyond_0004/)](https://theevilbit.github.io/beyond/beyond_0004/)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 111
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a macOS System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, for MacOS it is recommended to select "Traditional Endpoints".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious CronTab Creation or Modification

Cron is a time-based job scheduler in Unix-like operating systems, including macOS, used to automate repetitive tasks. Adversaries may exploit cron to maintain persistence by scheduling malicious scripts or commands. The detection rule identifies unusual crontab modifications by non-standard processes, flagging potential misuse by threat actors seeking to establish persistence.

### Possible investigation steps

- Review the process name and executable path that triggered the alert to determine if it is a known legitimate application or a potentially malicious one.
- Examine the file path "/private/var/at/tabs/*" to identify any recent changes or additions to crontab entries that could indicate unauthorized scheduling of tasks.
- Investigate the user account associated with the process to determine if it has a history of legitimate crontab modifications or if it might be compromised.
- Check for any related alerts or logs around the same timeframe that might indicate additional suspicious activity or corroborate the use of cron for persistence.
- Analyze the command or script scheduled in the crontab entry to assess its purpose and potential impact on the system, looking for signs of malicious intent.


### False positive analysis

- System maintenance scripts or legitimate administrative tools may modify crontabs using non-standard processes. Review the process name and executable path to determine if the activity is part of routine maintenance.
- Development or testing environments might use scripts or automation tools that modify crontabs for legitimate purposes. Identify and document these processes to create exceptions in the detection rule.
- Some third-party applications may use cron jobs for updates or scheduled tasks. Verify the legitimacy of these applications and consider excluding their processes if they are known and trusted.
- User-initiated scripts that automate personal tasks could trigger this rule. Educate users on the implications of using cron for personal automation and establish a process for approving such scripts.
- Regularly review and update the list of excluded processes to ensure that only verified and non-threatening activities are exempt from detection.


### Response and remediation

- Immediately isolate the affected macOS system from the network to prevent potential lateral movement or further execution of malicious tasks.
- Terminate any suspicious processes identified as modifying the crontab, especially those not typically associated with crontab modifications, such as python or osascript.
- Review and remove any unauthorized or suspicious entries in the crontab file located at /private/var/at/tabs/* to eliminate persistence mechanisms established by the threat actor.
- Conduct a thorough scan of the system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any additional malware or malicious scripts.
- Restore the system from a known good backup if the integrity of the system is in question and ensure all security patches and updates are applied.
- Escalate the incident to the security operations center (SOC) or incident response team for further analysis and to determine if additional systems are affected.
- Implement enhanced monitoring and logging for crontab modifications and related processes to detect and respond to similar threats in the future.


## Rule Query

```eql
file where host.os.type == "macos" and event.type != "deletion" and process.name != null and
  file.path like "/private/var/at/tabs/*" and not process.executable == "/usr/bin/crontab"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Scheduled Task/Job
- Id: T1053
- Reference URL: [[https://attack.mitre.org/techniques/T1053/](https://attack.mitre.org/techniques/T1053/)](https://attack.mitre.org/techniques/T1053/)
- Sub Technique:
  - Name: Cron
- Id: T1053.003
- Reference URL: [[https://attack.mitre.org/techniques/T1053/003/](https://attack.mitre.org/techniques/T1053/003/)](https://attack.mitre.org/techniques/T1053/003/)