﻿---
title: Apple Script Execution followed by Network Connection
description: Detects execution via the Apple script interpreter (osascript) followed by a network connection from the same process within a short time period. Adversaries...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/execution_scripting_osascript_exec_followed_by_netcon
products:
  - Elastic Security
---

# Apple Script Execution followed by Network Connection
Detects execution via the Apple script interpreter (osascript) followed by a network connection from the same process
within a short time period. Adversaries may use malicious scripts for execution and command and control.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network*
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://developer.apple.com/library/archive/documentation/LanguagesUtilities/Conceptual/MacAutomationScriptingGuide/index.html](https://developer.apple.com/library/archive/documentation/LanguagesUtilities/Conceptual/MacAutomationScriptingGuide/index.html)](https://developer.apple.com/library/archive/documentation/LanguagesUtilities/Conceptual/MacAutomationScriptingGuide/index.html)
- [[https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml](https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml)](https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Command and Control
- Tactic: Execution
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 112
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a macOS System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, for MacOS it is recommended to select "Traditional Endpoints".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Apple Script Execution followed by Network Connection

AppleScript, a scripting language for macOS, automates tasks by controlling applications and system functions. Adversaries exploit it to execute scripts that establish unauthorized network connections, facilitating command and control activities. The detection rule identifies such abuse by monitoring the osascript process for script execution followed by network activity, excluding local and private IP ranges, within a short timeframe.

### Possible investigation steps

- Review the process details for the osascript execution event, focusing on the process.entity_id and host.id to understand the context of the script execution.
- Examine the network connection details associated with the osascript process, particularly the destination IP address, to determine if it is known or suspicious, and check if it falls outside the excluded IP ranges.
- Investigate the script content or command line arguments used in the osascript execution to identify any potentially malicious or unexpected behavior.
- Check the timeline of events to see if there are any other related or suspicious activities occurring on the same host around the time of the osascript execution and network connection.
- Correlate the osascript activity with any other alerts or logs from the same host to identify patterns or additional indicators of compromise.
- Assess the user account associated with the osascript process to determine if it is a legitimate user or if there are signs of account compromise.


### False positive analysis

- Legitimate automation scripts may trigger the rule if they execute osascript and establish network connections. Review the script's purpose and source to determine if it is authorized.
- System management tools that use AppleScript for remote administration can cause false positives. Identify these tools and consider creating exceptions for their known processes.
- Software updates or applications that use AppleScript for network communication might be flagged. Verify the application's legitimacy and update the rule to exclude these specific processes or IP addresses.
- Development environments that utilize AppleScript for testing or deployment may inadvertently match the rule. Ensure these environments are recognized and excluded from monitoring if they are trusted.
- Regularly review and update the list of excluded IP ranges and processes to ensure they reflect the current network and application landscape, minimizing unnecessary alerts.


### Response and remediation

- Immediately isolate the affected macOS host from the network to prevent further unauthorized access or data exfiltration.
- Terminate the osascript process identified in the alert to stop any ongoing malicious activity.
- Conduct a thorough review of the executed AppleScript to identify any malicious commands or payloads and remove any associated files or scripts from the system.
- Reset credentials for any accounts that were accessed or could have been compromised during the incident.
- Apply security patches and updates to the macOS system to address any vulnerabilities that may have been exploited.
- Monitor network traffic for any further suspicious activity originating from the affected host or similar patterns across other systems.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems have been compromised.


## Rule Query

```eql
sequence by host.id, process.entity_id with maxspan=30s
 [process where host.os.type == "macos" and event.type == "start" and process.name == "osascript"]
 [network where host.os.type == "macos" and event.type == "start" and process.name == "osascript" and
   not cidrmatch(destination.ip, 
       "240.0.0.0/4", "233.252.0.0/24", "224.0.0.0/4", "198.19.0.0/16", "192.18.0.0/15", 
       "192.0.0.0/24", "10.0.0.0/8", "127.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12", 
       "192.0.2.0/24", "192.31.196.0/24", "192.52.193.0/24", "192.168.0.0/16", "192.88.99.0/24", 
       "100.64.0.0/10", "192.175.48.0/24", "198.18.0.0/15", "198.51.100.0/24", "203.0.113.0/24",
       "::1", "FE80::/10", "FF00::/8")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: AppleScript
- Id: T1059.002
- Reference URL: [[https://attack.mitre.org/techniques/T1059/002/](https://attack.mitre.org/techniques/T1059/002/)](https://attack.mitre.org/techniques/T1059/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Ingress Tool Transfer
- Id: T1105
- Reference URL: [[https://attack.mitre.org/techniques/T1105/](https://attack.mitre.org/techniques/T1105/)](https://attack.mitre.org/techniques/T1105/)