﻿---
title: Suspicious Automator Workflows Execution
description: Identifies the execution of the Automator Workflows process followed by a network connection from it's XPC service. Adversaries may drop a custom workflow...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/execution_script_via_automator_workflows
products:
  - Elastic Security
---

# Suspicious Automator Workflows Execution
Identifies the execution of the Automator Workflows process followed by a network connection from it's XPC service.
Adversaries may drop a custom workflow template that hosts malicious JavaScript for Automation (JXA) code as an
alternative to using osascript.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network*
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://posts.specterops.io/persistent-jxa-66e1c3cd1cf5](https://posts.specterops.io/persistent-jxa-66e1c3cd1cf5)](https://posts.specterops.io/persistent-jxa-66e1c3cd1cf5)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Execution
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 111
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a macOS System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, for MacOS it is recommended to select "Traditional Endpoints".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Automator Workflows Execution

Automator, a macOS utility, allows users to automate repetitive tasks through workflows. Adversaries can exploit this by embedding malicious JavaScript for Automation (JXA) in custom workflows, executing harmful scripts. The detection rule identifies this threat by monitoring the Automator process and subsequent network activity, flagging potential misuse when these actions occur in quick succession.

### Possible investigation steps

- Review the process execution details for the Automator process on the affected host, focusing on the timestamp and user context to determine if the execution was expected or authorized.
- Examine the network activity associated with the com.apple.automator.runner process to identify any unusual or suspicious external connections, including destination IP addresses and domains.
- Check for any recent changes or additions to Automator workflows on the host, especially those containing JavaScript for Automation (JXA) code, to identify potential malicious modifications.
- Investigate the user account associated with the Automator process execution to determine if there are any signs of compromise or unauthorized access.
- Correlate the alert with other security events or logs from the same host around the same timeframe to identify any additional indicators of compromise or related suspicious activities.


### False positive analysis

- Legitimate Automator workflows: Users may have legitimate workflows that trigger network connections, such as automated data uploads or API calls. To handle these, identify and document known safe workflows and create exceptions for them in the detection rule.
- Frequent developer activity: Developers using Automator for testing or development purposes might frequently trigger this rule. Consider excluding specific user accounts or development environments from the rule to reduce noise.
- System maintenance tasks: Some system maintenance or administrative tasks might use Automator workflows that connect to the network. Review and whitelist these tasks if they are verified as non-threatening.
- Third-party applications: Certain third-party applications may use Automator workflows as part of their normal operation. Identify these applications and exclude their processes from the rule if they are deemed safe.


### Response and remediation

- Immediately isolate the affected macOS host from the network to prevent further malicious activity and potential lateral movement.
- Terminate the Automator process and any associated XPC services, such as "com.apple.automator.runner," to stop the execution of the malicious workflow.
- Conduct a thorough review of the affected system to identify and remove any malicious JavaScript for Automation (JXA) scripts or custom workflow templates that may have been dropped by the adversary.
- Restore the system from a known good backup if any unauthorized changes or persistent threats are detected that cannot be easily remediated.
- Escalate the incident to the security operations team for further analysis and to determine if additional systems may be affected.
- Implement additional monitoring on the affected host and similar systems to detect any recurrence of suspicious Automator activity, focusing on process and network activity patterns.
- Update endpoint protection and intrusion detection systems to recognize and block similar threats in the future, leveraging the MITRE ATT&CK framework details for enhanced detection capabilities.


## Rule Query

```eql
sequence by host.id, process.entity_id with maxspan=15s
 [process where host.os.type == "macos" and event.type in ("start", "process_started") and process.name == "Automator"]
 [network where host.os.type == "macos"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)