﻿---
title: DNS Request for IP Lookup Service via Unsigned Binary
description: Detects when a DNS request is made for an IP lookup service to determine the external IP address of the system via an unsigned or untrusted binary. This...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/discovery_dns_request_for_ip_lookup_service
products:
  - Elastic Security
---

# DNS Request for IP Lookup Service via Unsigned Binary
Detects when a DNS request is made for an IP lookup service to determine the external IP address of the
system via an unsigned or untrusted binary. This is commonly used by malware for reconnaissance before
establishing C2 connections.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Discovery
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating DNS Request for IP Lookup Service via Unsigned Binary

This detects an unsigned or untrusted process on macOS performing DNS lookups for common “what is my public IP” and geolocation services, a frequent reconnaissance step before external communications. It matters because malware uses the host’s external IP and region to choose C2 infrastructure, gate payload delivery, or evade sandboxing. A typical pattern is a dropped, unsigned Mach-O or script resolving api.ipify.org or ipinfo.io immediately after execution, then initiating outbound beacons.

### Possible investigation steps

- Identify the initiating process and parent chain, then validate whether the binary is expected for the host/user and whether it is actually unsigned versus a transient signature collection issue.
- Review the same process’s near-term network activity for follow-on HTTP(S) requests to the resolved service and any subsequent connections to rare/new domains or IPs that could indicate C2 staging.
- Pivot from the resolved domain to other endpoints to determine prevalence and timing, then prioritize isolated single-host hits with recent first-seen binaries.
- Examine how the binary was introduced by correlating with recent downloads, archive mounts, installer executions, or quarantine/Gatekeeper events around the process start time.
- Acquire and analyze the binary (hash reputation, static strings, entitlements, persistence mechanisms, and launch agents/daemons) to confirm intent and scope of compromise.


### False positive analysis

- A developer-built or locally compiled macOS utility/script (run from a user directory) performs a “what is my public IP” DNS lookup for telemetry, diagnostics, or environment detection, and is flagged because it lacks a trusted code signature.
- An unsigned helper binary dropped by a legitimate installer/updater workflow briefly runs during setup to validate external connectivity or geolocation by resolving an IP-lookup domain, and is detected before the binary is signed or placed in its final trusted location.


### Response and remediation

- Isolate the affected macOS host from the network if the unsigned process continues to resolve IP-lookup domains (e.g., api.ipify.org, ipinfo.io) or initiates new outbound connections immediately after the lookup.
- Quarantine the unsigned executable and any associated scripts from disk (preserving path, hashes, and a copy for analysis) and remove its persistence artifacts such as newly created LaunchAgents/LaunchDaemons, login items, or cron entries tied to the same binary.
- Block the observed IP-lookup domains used by the unsigned process at DNS/web egress and add temporary deny rules for any follow-on suspicious destinations the process contacted after resolution.
- Reset compromised credentials and invalidate active sessions for the logged-in user if the process originated from user-writable locations (Downloads, Desktop, /tmp) or if additional discovery/collection behavior is found on the host.
- Reimage or restore the endpoint from a known-good state when persistence or tampering is confirmed, then verify Gatekeeper/XProtect status, re-enable security tooling, and monitor for recurrence of the same binary hash or domain pattern.
- Escalate to the incident response team if the unsigned binary is newly seen in the environment, appears on multiple hosts, or is followed by connections to rare domains/IPs indicative of staging or command-and-control.


## Rule Query

```eql
dns where host.os.type == "macos" and event.action == "lookup_result" and 
  (process.code_signature.trusted == false or process.code_signature.exists == false) and
  dns.question.name like~ ("*ip-api.com*", "*ipwho.is*", "*checkip.dyndns.org*", "*api.ipify.org*",
                           "*api.npoint.io*", "*whatismyip.akamai.com*", "*bot.whatismyipaddress.com*",
                           "*ifcfg.me*", "*ifconfig.me*", "*ident.me*", "*ipof.in*", "*ip.tyk.nu*",
                           "*ipwhois.app*", "*freeipapi.com*", "*icanhazip.com*", "*curlmyip.com*",
                           "*wgetip.com*", "*eth0.me*", "*ipecho.net*", "*ip.appspot.com*",
                           "*api.myip.com*", "*geoiptool.com*", "*api.2ip.ua*", "*api.ip.sb*",
                           "*ipinfo.io*", "*checkip.amazonaws.com*", "*wtfismyip.com*", "*iplogger.*",
                           "*freegeoip.net*", "*freegeoip.app*", "*myip.ipip.net*", "*geoplugin.net*",
                           "*myip.dnsomatic.com*", "*www.geoplugin.net*", "*api64.ipify.org*",
                           "*ip4.seeip.org*", "*.geojs.io*", "*portmap.io*", "*api.db-ip.com*",
                           "*geolocation-db.com*", "*inet-ip.info*", "*httpbin.org*", "*myip.opendns.com*") and
  not process.executable like "/Users/*/Library/Developer/CoreSimulator/*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Network Configuration Discovery
- Id: T1016
- Reference URL: [[https://attack.mitre.org/techniques/T1016/](https://attack.mitre.org/techniques/T1016/)](https://attack.mitre.org/techniques/T1016/)
- Sub Technique:
  - Name: Internet Connection Discovery
- Id: T1016.001
- Reference URL: [[https://attack.mitre.org/techniques/T1016/001/](https://attack.mitre.org/techniques/T1016/001/)](https://attack.mitre.org/techniques/T1016/001/)