﻿---
title: Attempt to Unload Elastic Endpoint Security Kernel Extension
description: Identifies attempts to unload the Elastic Endpoint Security kernel extension via the kextunload command. Rule type: eql Rule indices: logs-endpoint.events.*...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_unload_endpointsecurity_kext
products:
  - Elastic Security
---

# Attempt to Unload Elastic Endpoint Security Kernel Extension
Identifies attempts to unload the Elastic Endpoint Security kernel extension via the kextunload command.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 111
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a macOS System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, for MacOS it is recommended to select "Traditional Endpoints".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Attempt to Unload Elastic Endpoint Security Kernel Extension

Elastic Endpoint Security's kernel extension is crucial for monitoring and protecting macOS systems by intercepting and analyzing system-level events. Adversaries may attempt to unload this extension using the `kextunload` command to evade detection and impair defenses. The detection rule identifies such attempts by monitoring process events related to the `kextunload` command targeting the security extension, flagging potential defense evasion activities.

### Possible investigation steps

- Review the process event details to confirm the presence of the `kextunload` command targeting "EndpointSecurity.kext" in the process arguments.
- Identify the user account associated with the process event to determine if the action was initiated by an authorized or suspicious user.
- Check the host's recent activity logs for any other unusual or unauthorized actions that might indicate a broader attack or compromise.
- Investigate the source of the command execution by examining the parent process and any related processes to understand how the `kextunload` command was initiated.
- Assess the system for any signs of tampering or additional indicators of compromise, such as unauthorized file modifications or unexpected network connections.
- Correlate this event with other alerts or logs from the same host or user to identify potential patterns or coordinated activities.


### False positive analysis

- System administrators performing routine maintenance may trigger the rule when testing or updating kernel extensions. To manage this, create exceptions for known maintenance activities by whitelisting specific user accounts or processes during scheduled maintenance windows.
- Legitimate software updates or installations that require unloading the kernel extension might be flagged. To handle this, monitor and document regular update schedules and create exceptions for these activities, ensuring they align with expected update patterns.
- Security testing or audits conducted by authorized personnel could also trigger the rule. Implement a process to temporarily disable the rule or whitelist specific testing tools and accounts during these audits to prevent false positives.
- Development environments where kernel extensions are frequently loaded and unloaded for testing purposes may generate alerts. Consider setting up a separate monitoring profile for development systems with adjusted thresholds or exceptions to accommodate these activities.


### Response and remediation

- Immediately isolate the affected macOS system from the network to prevent further unauthorized actions or potential lateral movement by the adversary.
- Terminate any unauthorized processes related to the `kextunload` command to stop the attempt to unload the Elastic Endpoint Security kernel extension.
- Conduct a thorough review of system logs and process execution history to identify any additional suspicious activities or indicators of compromise associated with the adversary's attempt.
- Restore the Elastic Endpoint Security kernel extension if it was successfully unloaded, ensuring that the system's protective measures are fully operational.
- Update and patch the macOS system and all security software to the latest versions to mitigate any known vulnerabilities that could be exploited by adversaries.
- Implement additional monitoring and alerting for any future attempts to execute the `kextunload` command, particularly targeting security-related kernel extensions.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if broader organizational defenses need to be adjusted.


## Rule Query

```eql
process where host.os.type == "macos" and event.type in ("start", "process_started") and
 process.name == "kextunload" and process.args like~ ("*.EndpointSecurity", "/System/Library/Extensions/EndpointSecurity.kext", "EndpointSecurity.kext")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Tools
- Id: T1562.001
- Reference URL: [[https://attack.mitre.org/techniques/T1562/001/](https://attack.mitre.org/techniques/T1562/001/)](https://attack.mitre.org/techniques/T1562/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Kernel Modules and Extensions
- Id: T1547.006
- Reference URL: [[https://attack.mitre.org/techniques/T1547/006/](https://attack.mitre.org/techniques/T1547/006/)](https://attack.mitre.org/techniques/T1547/006/)