﻿---
title: Attempt to Install Root Certificate
description: Adversaries may install a root certificate on a compromised system to avoid warnings when connecting to their command and control servers. Root certificates...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_install_root_certificate
products:
  - Elastic Security
---

# Attempt to Install Root Certificate
Adversaries may install a root certificate on a compromised system to avoid warnings when connecting to their command
and control servers. Root certificates are used in public key cryptography to identify a root certificate authority
(CA). When a root certificate is installed, the system or application will trust certificates in the root's chain of
trust that have been signed by the root certificate.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://ss64.com/osx/security-cert.html](https://ss64.com/osx/security-cert.html)](https://ss64.com/osx/security-cert.html)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 110
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a macOS System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, for MacOS it is recommended to select "Traditional Endpoints".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Attempt to Install Root Certificate

Root certificates are pivotal in establishing trust within public key infrastructures, enabling secure communications by verifying the authenticity of digital certificates. Adversaries exploit this by installing unauthorized root certificates on compromised macOS systems, thereby bypassing security warnings and facilitating covert command and control communications. The detection rule identifies such activities by monitoring specific process executions related to certificate management, excluding known legitimate applications, thus highlighting potential malicious attempts to subvert trust controls.

### Possible investigation steps

- Review the process execution details to confirm the presence of the "security" process with the "add-trusted-cert" argument, as this indicates an attempt to add a root certificate.
- Check the parent process of the suspicious activity to ensure it is not one of the known legitimate applications, such as Bitdefender, as specified in the exclusion list.
- Investigate the user account associated with the process execution to determine if it is a legitimate user or potentially compromised.
- Examine recent system logs and network activity for any signs of unauthorized access or communication with known malicious command and control servers.
- Assess the system for any other indicators of compromise or unusual behavior that may suggest further malicious activity beyond the root certificate installation attempt.


### False positive analysis

- Security software installations or updates may trigger the rule as they often involve legitimate root certificate installations. Users can handle this by adding exceptions for known security software paths, such as Bitdefender, to prevent unnecessary alerts.
- System administrators performing routine maintenance or updates might install root certificates as part of their tasks. To mitigate this, create exceptions for processes executed by trusted admin accounts or during scheduled maintenance windows.
- Some enterprise applications may require the installation of root certificates for internal communications. Identify these applications and exclude their processes from the rule to avoid false positives.
- Development environments on macOS systems might involve testing with self-signed certificates, which could trigger the rule. Developers can be instructed to use designated test environments or have their processes excluded during development phases.


### Response and remediation

- Immediately isolate the affected macOS system from the network to prevent further unauthorized communications and potential data exfiltration.
- Revoke any unauthorized root certificates installed on the system by accessing the Keychain Access application and removing the suspicious certificates from the System Roots keychain.
- Conduct a thorough review of system logs and process execution history to identify any additional unauthorized changes or suspicious activities that may have occurred alongside the root certificate installation.
- Restore the system to a known good state using backups or system snapshots taken prior to the compromise, ensuring that any malicious changes are reverted.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if other systems in the network may be affected.
- Implement enhanced monitoring and alerting for similar activities by refining detection capabilities to include additional indicators of compromise (IOCs) related to unauthorized certificate installations.
- Review and update security policies and configurations to prevent unauthorized certificate installations, such as enforcing stricter access controls and requiring administrative approval for certificate management actions.


## Rule Query

```eql
process where host.os.type == "macos" and event.type in ("start", "process_started") and
  process.name == "security" and process.args like "add-trusted-cert" and
  (process.parent.name like~ ("osascript", "bash", "sh", "zsh", "Terminal", "Python*") or (process.parent.code_signature.exists == false or process.parent.code_signature.trusted == false))
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Subvert Trust Controls
- Id: T1553
- Reference URL: [[https://attack.mitre.org/techniques/T1553/](https://attack.mitre.org/techniques/T1553/)](https://attack.mitre.org/techniques/T1553/)
- Sub Technique:
  - Name: Install Root Certificate
- Id: T1553.004
- Reference URL: [[https://attack.mitre.org/techniques/T1553/004/](https://attack.mitre.org/techniques/T1553/004/)](https://attack.mitre.org/techniques/T1553/004/)