﻿---
title: Dylib Injection via Process Environment Variables
description: Detects the use of process environment variables (DYLD_INSERT_LIBRARIES or LD_PRELOAD) to inject a shared library into a binary at or prior to execution...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_dylib_injection_via_env_vars
products:
  - Elastic Security
---

# Dylib Injection via Process Environment Variables
Detects the use of process environment variables (DYLD_INSERT_LIBRARIES or LD_PRELOAD) to inject a shared
library into a binary at or prior to execution. A threat actor may use this technique to load a malicious
shared library for persistence, privilege escalation, and defense evasion. This activity is uncommon and
typically indicates malicious behavior.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*
- logs-endpoint.events.library-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://wojciechregula.blog/post/learn-xpc-exploitation-part-3-code-injections/](https://wojciechregula.blog/post/learn-xpc-exploitation-part-3-code-injections/)](https://wojciechregula.blog/post/learn-xpc-exploitation-part-3-code-injections/)
- [[https://attack.mitre.org/techniques/T1574/006/](https://attack.mitre.org/techniques/T1574/006/)](https://attack.mitre.org/techniques/T1574/006/)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Persistence
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Dylib Injection via Process Environment Variables

Dynamic library injection using DYLD_INSERT_LIBRARIES or LD_PRELOAD environment variables is a powerful technique that allows code to be loaded into a process's address space at runtime. While this capability exists for legitimate debugging and development purposes, threat actors abuse it to hook application functionality, steal credentials, intercept keystrokes, or execute malicious code within trusted processes. This detection rule identifies processes started with these injection environment variables set to non-empty values.

### Possible investigation steps

- Review the process.env_vars field to identify the specific dylib being injected via DYLD_INSERT_LIBRARIES or LD_PRELOAD and determine its file path.
- Locate the injected dylib file on the file system using the path from the environment variable and calculate its hash for threat intelligence lookups.
- Analyze the process.executable and process.name fields to identify the target application being hijacked and assess whether dylib injection makes sense for its normal operation.
- Examine the process.parent.executable and process.command_line to understand how the process with injection was launched and trace back to the initial execution vector.
- Review the code signature of the injected dylib using codesign or similar tools to determine if it is signed, and by whom.
- Check for file creation events to determine when the malicious dylib was placed on the system and how it was delivered.
- Correlate with other security events on the same host to identify if the injection is part of a larger attack chain, such as credential theft or keylogging.


### False positive analysis

- Xcode and iOS Simulator use DYLD_INSERT_LIBRARIES for debugging and testing purposes during application development. These paths are already excluded in the query.
- Security research and reverse engineering tools may use library injection for analysis. Verify with security teams if such activities are expected.
- Some legitimate applications use library injection for specific functionality. Document these applications and create targeted exceptions after verification.
- Homebrew and development environments may occasionally use these environment variables. Confirm with development teams before creating exclusions.


### Response and remediation

- Immediately terminate the process using malicious dylib injection to stop any ongoing malicious activity such as credential theft or keylogging.
- Quarantine the injected dylib file for forensic analysis and malware reverse engineering.
- Remove the malicious dylib from the system and ensure it cannot be reloaded through persistence mechanisms.
- Investigate how the dylib was placed on the system and remediate the initial access or delivery mechanism.
- Review System Integrity Protection (SIP) status on the affected system, as SIP should normally prevent DYLD injection into protected system processes.
- Scan the system for additional indicators of compromise, persistence mechanisms, or lateral movement.
- Reset any credentials that may have been exposed through the injection, particularly if the target application handles sensitive authentication data.
- Escalate to the incident response team for comprehensive analysis if the injection indicates active compromise.


## Rule Query

```eql
sequence by process.entity_id with maxspan=15s
  [process where host.os.type == "macos" and event.type == "start" and event.action == "exec" and
    process.env_vars like ("DYLD_INSERT_LIBRARIES=?*", "LD_PRELOAD=?*") and
    not process.env_vars like ("DYLD_INSERT_LIBRARIES=", "LD_PRELOAD=", "LD_PRELOAD=<null>") and
    not process.executable like ("/Users/*/Library/Developer/Xcode/*", "/Users/*/Library/Developer/CoreSimulator/*") and
    not process.parent.executable like ("/usr/bin/xcrun", "/Applications/Xcode*.app/*", "/Library/Developer/*")]
  [library where host.os.type == "macos" and event.action == "load" and
    not dll.name like ("*.aot", "*.so") and
    not dll.code_signature.trusted == true and
    not dll.path like ("/System/*", "/usr/lib/*", "/opt/homebrew/*", "/private/var/folders/*",
                       "/Library/Apple/*", "/Library/Developer/*",
                       "/Users/*/Library/Developer/Xcode/*", "/Users/*/Library/Developer/CoreSimulator/*")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: Dynamic Linker Hijacking
- Id: T1574.006
- Reference URL: [[https://attack.mitre.org/techniques/T1574/006/](https://attack.mitre.org/techniques/T1574/006/)](https://attack.mitre.org/techniques/T1574/006/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: Dynamic Linker Hijacking
- Id: T1574.006
- Reference URL: [[https://attack.mitre.org/techniques/T1574/006/](https://attack.mitre.org/techniques/T1574/006/)](https://attack.mitre.org/techniques/T1574/006/)