﻿---
title: Keychain CommandLine Interaction via Unsigned or Untrusted Process
description: Adversaries may collect the keychain storage data from a system to acquire credentials. Keychains are the built-in way for macOS to keep track of users'...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_credentials_keychains
products:
  - Elastic Security
---

# Keychain CommandLine Interaction via Unsigned or Untrusted Process
Adversaries may collect the keychain storage data from a system to acquire credentials. Keychains are the built-in way
for macOS to keep track of users' passwords and credentials for many services and features such as WiFi passwords,
websites, secure notes and certificates.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://objective-see.com/blog/blog_0x25.html](https://objective-see.com/blog/blog_0x25.html)](https://objective-see.com/blog/blog_0x25.html)
- [[https://securelist.com/calisto-trojan-for-macos/86543/](https://securelist.com/calisto-trojan-for-macos/86543/)](https://securelist.com/calisto-trojan-for-macos/86543/)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 212
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a macOS System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, for MacOS it is recommended to select "Traditional Endpoints".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/current/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Keychain CommandLine Interaction via Unsigned or Untrusted Process

macOS keychains securely store user credentials, such as passwords and certificates, essential for system and application authentication. Adversaries may target these directories to extract sensitive information, potentially compromising user accounts and system integrity. The detection rule identifies suspicious access attempts by monitoring process activities related to keychain directories, excluding known legitimate processes and actions, thus highlighting potential unauthorized access attempts.

### Possible investigation steps

- Review the process details that triggered the alert, focusing on the process.args field to identify the specific keychain directory accessed and the nature of the access attempt.
- Examine the process.parent.executable and process.executable fields to determine the origin of the process and assess whether it is a known or potentially malicious application.
- Investigate the process.Ext.effective_parent.executable field to trace the parent process chain and identify any unusual or unauthorized parent processes that may have initiated the access.
- Check for any recent changes or installations on the system that could explain the access attempt, such as new software or updates that might interact with keychain directories.
- Correlate the alert with other security events or logs from the same host to identify any patterns or additional suspicious activities that could indicate a broader compromise.


### False positive analysis

- Processes related to legitimate security applications like Microsoft Defender, JumpCloud Agent, and Rapid7 IR Agent may trigger false positives. Users can mitigate this by ensuring these applications are included in the exclusion list for process executables and effective parent executables.
- Routine administrative tasks involving keychain management, such as setting keychain settings or importing certificates, might be flagged. To handle this, users should add these specific actions to the exclusion list for process arguments.
- Applications like OpenVPN Connect and JAMF management tools that interact with keychain directories for legitimate purposes can cause false alerts. Users should verify these applications are part of the exclusion list for parent executables to prevent unnecessary alerts.
- Regular system maintenance or updates that involve keychain access might be misinterpreted as suspicious. Users should monitor these activities and adjust the exclusion criteria as needed to accommodate known maintenance processes.


### Response and remediation

- Immediately isolate the affected macOS system from the network to prevent further unauthorized access or data exfiltration.
- Terminate any suspicious processes identified by the detection rule that are attempting to access keychain directories without legitimate reasons.
- Conduct a thorough review of the system's keychain access logs to identify any unauthorized access or modifications to keychain files.
- Change all passwords and credentials stored in the keychain on the affected system to prevent potential misuse of compromised credentials.
- Restore the system from a known good backup if unauthorized access has led to system integrity issues or data corruption.
- Implement additional monitoring on the affected system to detect any further unauthorized access attempts, focusing on the keychain directories and related processes.
- Escalate the incident to the security operations team for further investigation and to determine if the threat is part of a larger attack campaign.


## Rule Query

```eql
process where host.os.type == "macos" and event.type in ("start", "process_started") and event.action == "exec" and
  process.args like ("/Users/*/Library/Keychains/*", "/Library/Keychains/*", "login.keychain-db", "login.keychain") and 
  ((process.code_signature.trusted == false or process.code_signature.exists == false) or 
   (process.name in ("bash", "sh", "zsh", "osascript", "cat", "echo", "cp") and 
   (process.parent.code_signature.trusted == false or process.parent.code_signature.exists == false)))
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Credentials from Password Stores
- Id: T1555
- Reference URL: [[https://attack.mitre.org/techniques/T1555/](https://attack.mitre.org/techniques/T1555/)](https://attack.mitre.org/techniques/T1555/)
- Sub Technique:
  - Name: Keychain
- Id: T1555.001
- Reference URL: [[https://attack.mitre.org/techniques/T1555/001/](https://attack.mitre.org/techniques/T1555/001/)](https://attack.mitre.org/techniques/T1555/001/)