﻿---
title: Suspicious Outbound Network Connection via Unsigned Binary
description: Detects the execution of an unsigned or untrusted binary followed by an outbound network connection to a raw IP address on a non-standard port. Many malicious...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_suspicious_outbound_network_via_unsigned_binary
products:
  - Elastic Security
---

# Suspicious Outbound Network Connection via Unsigned Binary
Detects the execution of an unsigned or untrusted binary followed by an outbound network connection to a
raw IP address on a non-standard port. Many malicious payloads will connect directly to C2 or a payload
server using non-standard ports.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*
- logs-endpoint.events.network-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Command and Control
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Outbound Network Connection via Unsigned Binary

Unsigned or untrusted binaries making outbound network connections to raw IP addresses on non-standard ports is a significant indicator of malware activity. Legitimate macOS applications are typically code-signed by Apple or identified developers, while malware often lacks valid signatures. This detection rule identifies this suspicious combination of unsigned binaries with network activity to detect potential command and control communication or data exfiltration attempts.

### Possible investigation steps

- Review the process.executable and process.hash fields to identify the unsigned binary and search for its hash in threat intelligence databases and malware repositories.
- Examine the process.code_signature fields to understand why the binary is untrusted, including whether it lacks a signature entirely or has an invalid or revoked certificate.
- Analyze the destination.ip and destination.port fields to identify the remote endpoint and research it in threat intelligence sources for known malicious infrastructure.
- Investigate the process.parent.executable and process.command_line to understand how the unsigned binary was launched and trace the execution chain to the initial access vector.
- Review file.creation and file.modification events to determine when and how the unsigned binary was placed on the system.
- Check for persistence mechanisms that may have been created by or for the unsigned binary, such as LaunchAgents, LaunchDaemons, or cron jobs.
- Correlate with other network events from the same host to identify patterns of C2 communication or additional indicators of compromise.


### False positive analysis

- Custom internal tools developed in-house may be unsigned and require network access for legitimate business purposes. Verify with development teams and consider adding specific exclusions.
- Development builds and testing environments may use unsigned binaries during the software development lifecycle. Document these activities and create targeted exceptions.
- Open-source utilities compiled locally may not have code signatures. Evaluate these on a case-by-case basis and add to exclusion lists if verified safe.
- Homebrew and other package manager binaries are already excluded but verify that legitimate tools from these sources are not being flagged.


### Response and remediation

- Immediately terminate the unsigned process and block the destination IP address at network perimeters and endpoint firewalls.
- Quarantine the unsigned binary for forensic analysis and malware reverse engineering.
- Conduct a comprehensive scan of the affected system to identify additional malware components, persistence mechanisms, or lateral movement indicators.
- Investigate how the unsigned binary was delivered to the system and remediate the initial access vector.
- Review other systems in the environment for the same binary hash or similar indicators of compromise.
- Implement application allowlisting policies to prevent unauthorized unsigned binaries from executing.
- Escalate to the incident response team for further investigation if the binary is confirmed malicious.


## Rule Query

```eql
sequence by process.entity_id with maxspan=1m
  [process where host.os.type == "macos" and event.type == "start" and event.action == "exec" and 
    (process.code_signature.trusted == false or process.code_signature.exists == false) and
    process.args_count == 1 and
    not process.executable like "/opt/homebrew/*"]
  [network where host.os.type == "macos" and event.type == "start" and 
    destination.domain == null and 
    not destination.port in (443, 80, 53, 22, 25, 587, 993, 465, 8080, 8200, 9200) and 
    destination.port < 49152 and
    not cidrmatch(destination.ip, "0.0.0.0", "240.0.0.0/4", "233.252.0.0/24", "224.0.0.0/4", 
                  "198.19.0.0/16", "192.18.0.0/15", "192.0.0.0/24", "10.0.0.0/8", "127.0.0.0/8", 
                  "169.254.0.0/16", "172.16.0.0/12", "192.0.2.0/24", "192.31.196.0/24", 
                  "192.52.193.0/24", "192.168.0.0/16", "192.88.99.0/24", "100.64.0.0/10", 
                  "192.175.48.0/24", "198.18.0.0/15", "198.51.100.0/24", "203.0.113.0/24",
                  "::1", "FE80::/10", "FF00::/8")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Non-Standard Port
- Id: T1571
- Reference URL: [[https://attack.mitre.org/techniques/T1571/](https://attack.mitre.org/techniques/T1571/)](https://attack.mitre.org/techniques/T1571/)