﻿---
title: Perl Outbound Network Connection
description: Detects when Perl makes an outbound network connection to a non-private IP address. Perl is a scripting language that comes pre-installed on macOS and...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_perl_outbound_network_connection
products:
  - Elastic Security
---

# Perl Outbound Network Connection
Detects when Perl makes an outbound network connection to a non-private IP address. Perl is a scripting
language that comes pre-installed on macOS and offers extensive capabilities for adversaries. Its use for
network connections on macOS systems is uncommon and potentially suspicious.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*
- logs-endpoint.events.process-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Command and Control
- Tactic: Execution
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Perl Outbound Network Connection

This rule detects Perl starting on macOS and then initiating an outbound connection to a public (non-private) IP, a pattern that stands out because Perl rarely performs direct network reach-outs in normal macOS workflows. Attackers often abuse Perl as a built-in “living off the land” runtime to beacon to external command-and-control over HTTP/S or to fetch and execute a second-stage payload from an internet host.

### Possible investigation steps

- Review the full command line, parent/child process tree, execution context (user, TTY, working directory), and referenced script/module paths to determine whether the run was expected or suspicious.
- Pivot on the external destination (IP, port, and any resolved domain from DNS telemetry) to assess reputation, hosting characteristics, and whether other endpoints have recently contacted the same infrastructure.
- Examine connection characteristics (protocol, TLS SNI/certificate, HTTP headers/user-agent, data volume, and timing) to identify staged downloads or beacon-like periodicity.
- Correlate nearby file activity for newly created or modified scripts, temp artifacts, or downloaded payloads, and validate them via hashes, signatures, and known-good baselines.
- Check for follow-on behavior consistent with persistence or lateral movement, such as new launchd/cron items, suspicious login items, or additional interpreters and shells spawned from the same lineage.


### False positive analysis

- A legitimate Perl script run by an administrator or scheduled maintenance task (e.g., log rotation, health checks, or API polling) may connect to a public service endpoint over HTTP/S, matching the Perl exec followed by a non-private destination IP pattern.
- A developer workflow that uses Perl one-liners or project scripts to fetch dependencies, query internet-hosted resources, or validate external URLs can generate outbound connections to public IPs that appear unusual on endpoints without an established baseline for Perl network use.


### Response and remediation

- Isolate the affected macOS host from the network (or block the specific destination IP/port at the egress firewall) and terminate the suspicious `perl` process to stop any active command-and-control or payload download.
- Collect and preserve the Perl command line, referenced script paths, current working directory, any newly written files (especially in `/tmp`, `/var/tmp`, and the user’s `~/Library`), and the full process tree for forensic review before cleanup.
- Remove or quarantine the identified Perl script and any downloaded payloads, then eradicate persistence by deleting malicious `launchd` agents/daemons, cron entries, and suspicious Login Items created around the time of the outbound connection.
- Reimage or restore the endpoint from a known-good source if integrity cannot be confidently validated, rotate credentials used on the device, and invalidate active sessions/tokens that may have been exposed to the Perl process.
- Escalate to IR/forensics immediately if the destination infrastructure is contacted by multiple hosts, the Perl process runs under a privileged context, or you observe repeated beacon-like connections or evidence of persistence beyond a single script execution.
- Harden by restricting interpreter execution (Perl, Python, Ruby) via endpoint controls, enforcing outbound allowlisting/proxying for user endpoints, and adding detections for Perl launching network tools or writing executable content into user-writable directories.


## Rule Query

```eql
sequence by process.entity_id with maxspan=30s
  [process where host.os.type == "macos" and event.type == "start" and event.action == "exec" and
    process.name == "perl" and not process.args like "/usr/bin/xpath"]
  [network where host.os.type == "macos" and event.type == "start" and process.name == "perl" and
    not cidrmatch(destination.ip, 
        "10.0.0.0/8", "127.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12", 
        "192.0.0.0/24", "192.0.2.0/24", "192.168.0.0/16", "192.88.99.0/24",
        "224.0.0.0/4", "240.0.0.0/4", "::1", "FE80::/10", "FF00::/8")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)
- Sub Technique:
  - Name: Web Protocols
- Id: T1071.001
- Reference URL: [[https://attack.mitre.org/techniques/T1071/001/](https://attack.mitre.org/techniques/T1071/001/)](https://attack.mitre.org/techniques/T1071/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)