﻿---
title: Google Calendar C2 via Script Interpreter
description: Detects a two-stage Google Calendar C2 pattern where a scripting runtime (Node.js, Python, osascript) first connects to calendar.app.google to retrieve...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_google_calendar_c2_via_script
products:
  - Elastic Security
---

# Google Calendar C2 via Script Interpreter
Detects a two-stage Google Calendar C2 pattern where a scripting runtime (Node.js, Python, osascript) first
connects to calendar.app.google to retrieve a hidden C2 address, then initiates a secondary connection to the
decoded C2 host. This sequence is characteristic of packages using Unicode steganography in Google Calendar
events to stage dynamic command-and-control endpoints.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.veracode.com/resources/sophisticated-npm-attack-leveraging-unicode-steganography-and-google-calendar-c2](https://www.veracode.com/resources/sophisticated-npm-attack-leveraging-unicode-steganography-and-google-calendar-c2)](https://www.veracode.com/resources/sophisticated-npm-attack-leveraging-unicode-steganography-and-google-calendar-c2)
- [[https://www.koi.ai/blog/glassworm-first-self-propagating-worm-using-invisible-code-hits-openvsx-marketplace](https://www.koi.ai/blog/glassworm-first-self-propagating-worm-using-invisible-code-hits-openvsx-marketplace)](https://www.koi.ai/blog/glassworm-first-self-propagating-worm-using-invisible-code-hits-openvsx-marketplace)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Command and Control
- Tactic: Execution
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Google Calendar C2 via Script Interpreter

Threat actors increasingly abuse legitimate cloud services to establish covert command and control channels that blend with normal traffic and bypass traditional network security controls. Google Calendar has been weaponized as a C2 mechanism where attackers store encoded commands in calendar event descriptions, which malware then polls and executes. This detection rule identifies script interpreters connecting to Google Calendar API endpoints, which may indicate this living-off-the-land technique.

### Possible investigation steps

- Review the process.name and process.executable fields to identify which script interpreter is making the Google Calendar API connection and assess whether it is expected for the user or application context.
- Examine the process.command_line and process.args fields to understand what script or code is being executed that initiated the calendar connection.
- Check the process.parent.executable and process.parent.command_line to trace the process lineage and identify how the script interpreter was launched.
- Investigate the Google Workspace audit logs for the associated user account to review calendar events that may contain encoded commands or suspicious content.
- Review network connection details including dns.question.name and destination.ip to understand the specific Google API endpoints being accessed.
- Correlate with authentication events to identify which user account or service account OAuth tokens are being used for the calendar access.
- Search for similar activity across other endpoints to determine if this is an isolated incident or part of a broader campaign.


### False positive analysis

- Legitimate productivity applications may integrate with Google Calendar for scheduling and automation purposes. Verify the application's purpose and whether it is approved by IT.
- Custom automation scripts built by employees may access Google Calendar API for workflow automation. Review with the script owner to confirm legitimacy.
- Development and testing environments may trigger this detection when building calendar integrations. Document known development activities and create targeted exceptions.
- Third-party calendar sync applications may use script interpreters to interface with Google Calendar. Verify these are sanctioned applications.


### Response and remediation

- Immediately terminate the suspicious script interpreter process to stop any ongoing C2 communication.
- Revoke OAuth tokens and API credentials associated with the compromised Google account to prevent further unauthorized access.
- Review Google Workspace admin console for any unauthorized calendar events or modifications that may contain malicious content.
- Isolate the affected macOS system from the network while conducting forensic analysis.
- Perform a comprehensive scan for additional malware, persistence mechanisms, or lateral movement indicators.
- Reset the affected user's credentials and enable multi-factor authentication if not already in place.
- Implement application allowlisting to prevent unauthorized script interpreters from executing.
- Escalate to the security operations team for further investigation into potential data exfiltration or broader compromise.


## Rule Query

```eql
sequence by process.entity_id with maxspan=20s
  [network where host.os.type == "macos" and event.type == "start" and
    (process.name in ("node", "osascript") or process.name like "python*" or
     process.code_signature.trusted == false or process.code_signature.exists == false) and
    destination.domain like "calendar.app.google*"]
  [network where host.os.type == "macos" and event.type == "start" and destination.domain == null]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Web Service
- Id: T1102
- Reference URL: [[https://attack.mitre.org/techniques/T1102/](https://attack.mitre.org/techniques/T1102/)](https://attack.mitre.org/techniques/T1102/)
- Sub Technique:
  - Name: Bidirectional Communication
- Id: T1102.002
- Reference URL: [[https://attack.mitre.org/techniques/T1102/002/](https://attack.mitre.org/techniques/T1102/002/)](https://attack.mitre.org/techniques/T1102/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Python
- Id: T1059.006
- Reference URL: [[https://attack.mitre.org/techniques/T1059/006/](https://attack.mitre.org/techniques/T1059/006/)](https://attack.mitre.org/techniques/T1059/006/)
- Sub Technique:
  - Name: JavaScript
- Id: T1059.007
- Reference URL: [[https://attack.mitre.org/techniques/T1059/007/](https://attack.mitre.org/techniques/T1059/007/)](https://attack.mitre.org/techniques/T1059/007/)