﻿---
title: Executable File Download via Wget
description: Detects executable file downloads via wget to suspicious locations such as /tmp or /Users/Shared. Threat actors commonly use wget to download malicious...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_executable_download_via_wget
products:
  - Elastic Security
---

# Executable File Download via Wget
Detects executable file downloads via wget to suspicious locations such as /tmp or /Users/Shared. Threat
actors commonly use wget to download malicious payloads and additional tools for post-exploitation.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*
- logs-endpoint.events.file-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://attack.mitre.org/techniques/T1105/](https://attack.mitre.org/techniques/T1105/)](https://attack.mitre.org/techniques/T1105/)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Command and Control
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Executable File Download via Wget

This rule detects wget pulling down a Mach-O executable and writing it into commonly abused transient or shared directories on macOS, which often signals payload staging during ingress tool transfer. Attackers frequently run wget from a shell or scripted installer to fetch a second-stage binary into /tmp or /Users/Shared, then immediately execute it to establish command and control or deploy additional tooling.

### Possible investigation steps

- Pivot from the detected wget process to identify its parent process, user context, and full command line to determine whether it was launched by an interactive shell, script, or installer package.
- Review the network connection details from the wget execution (remote IP/domain, URL path, TLS certificate/SNI if available) and assess reputation plus whether it aligns with known internal software distribution.
- Inspect the downloaded Mach-O at the destination path by collecting its hash, signature/notarization status, and basic static traits (strings, embedded URLs, ad-hoc signing) to quickly judge legitimacy.
- Check for immediate follow-on activity from the same host such as execution of the new file, creation of persistence (LaunchAgents/Daemons, cron, login items), or additional tool downloads within the next few minutes.
- Scope for reuse by searching across endpoints for the same downloaded hash, filename, URL, or destination directory pattern to determine blast radius and whether this is a recurring delivery mechanism.


### False positive analysis

- An administrator or developer uses wget in a script to fetch an internal build or test Mach-O binary and stages it in /tmp or /Users/Shared for immediate execution during troubleshooting or CI-style workflows.
- A legitimate installation or update routine invokes wget to download a helper executable to a transient directory (for unpacking or preflight checks) before moving it into an application bundle, causing a short-lived write to /tmp-like paths.


### Response and remediation

- Isolate the affected macOS host from the network and terminate the active `wget` process to stop additional payload transfers or execution.
- Quarantine the downloaded Mach-O from `/tmp`, `/private/tmp`, `/var/tmp`, or `/Users/Shared` and preserve a copy plus the originating `wget` command/URL for analysis before removal.
- Hunt on the host for immediate follow-on execution of the downloaded file and remove any persistence artifacts created around the same time, such as new LaunchAgents/LaunchDaemons, login items, or cron entries pointing to the staged path.
- Block the observed download URL/domain/IP at egress controls and add allowlisting controls for approved internal distribution sources to reduce future misuse of `wget` for tool transfer.
- Escalate to incident response if the staged Mach-O is executed, unsigned/ad-hoc signed, establishes outbound connections to unapproved infrastructure, or the same hash/URL is found on multiple endpoints.
- Harden endpoints by restricting `wget` usage where possible, enforcing Gatekeeper/notarization and least-privilege execution, and adding monitoring/controls for executable writes and executions from world-writable directories.


## Rule Query

```eql
sequence by process.entity_id with maxspan=30s
  [network where host.os.type == "macos" and event.type == "start" and process.name == "wget"]
  [file where host.os.type == "macos" and event.action == "modification" and 
    process.name == "wget" and 
    file.path like ("/tmp/*", "/private/tmp/*", "/private/var/tmp/*", "/var/tmp/*", "/Users/Shared/*") and
    file.Ext.header_bytes like~ ("cffaedfe*", "cafebabe*")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Ingress Tool Transfer
- Id: T1105
- Reference URL: [[https://attack.mitre.org/techniques/T1105/](https://attack.mitre.org/techniques/T1105/)](https://attack.mitre.org/techniques/T1105/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: User Execution
- Id: T1204
- Reference URL: [[https://attack.mitre.org/techniques/T1204/](https://attack.mitre.org/techniques/T1204/)](https://attack.mitre.org/techniques/T1204/)
- Sub Technique:
  - Name: Malicious File
- Id: T1204.002
- Reference URL: [[https://attack.mitre.org/techniques/T1204/002/](https://attack.mitre.org/techniques/T1204/002/)](https://attack.mitre.org/techniques/T1204/002/)