﻿---
title: Pbpaste Execution via Unusual Parent Process
description: Detects when an unusual parent process like Node.js, Python, or osascript executes the pbpaste binary to access clipboard data. This technique has been...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/collection_pbpaste_execution_via_unusual_parent
products:
  - Elastic Security
---

# Pbpaste Execution via Unusual Parent Process
Detects when an unusual parent process like Node.js, Python, or osascript executes the pbpaste binary to
access clipboard data. This technique has been used by malware like OtterCookie to steal passwords and
seed phrases from the clipboard.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://jp.security.ntt/tech_blog/contagious-interview-ottercookie](https://jp.security.ntt/tech_blog/contagious-interview-ottercookie)](https://jp.security.ntt/tech_blog/contagious-interview-ottercookie)

**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Collection
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Pbpaste Execution via Unusual Parent Process

The pbpaste utility on macOS retrieves data from the system clipboard, making it a target for malware seeking to steal sensitive information such as passwords, cryptocurrency seed phrases, or authentication tokens. Threat actors, particularly those behind campaigns like OtterCookie, leverage scripting interpreters such as Node.js, Python, or osascript to programmatically access clipboard contents. This detection rule identifies suspicious process chains where these interpreters spawn pbpaste, indicating potential credential theft or data harvesting activity.

### Possible investigation steps

- Review the process.parent.name and process.parent.executable fields to identify which scripting interpreter spawned pbpaste and determine if this is expected behavior for the user or application context.
- Examine the process.parent.command_line field to understand what script or command initiated the clipboard access and assess whether it appears malicious or legitimate.
- Check for any network connections made by the parent process around the same time by correlating with network events, as clipboard data is often exfiltrated shortly after collection.
- Investigate the user account associated with the activity using the user.name field to determine if the behavior aligns with their typical work patterns.
- Review the process.parent.code_signature fields to verify whether the parent application is signed and trusted, as unsigned or untrusted interpreters are more suspicious.
- Search for related alerts or events on the same host within a short time window to identify if this is part of a larger attack chain.


### False positive analysis

- Legitimate automation tools and productivity applications may use pbpaste for clipboard operations as part of normal workflows. Verify the parent application and its purpose before escalating.
- Development and testing environments may trigger this detection when developers test clipboard functionality. Consider adding exclusions for known development tools after verification.
- Some password managers or clipboard utilities may spawn pbpaste for legitimate purposes. Document these applications and create targeted exceptions if confirmed safe.
- System administration scripts that manage clipboard data should be reviewed and allowlisted if they are part of approved IT operations.


### Response and remediation

- Immediately isolate the affected macOS device from the network to prevent potential data exfiltration if malicious activity is confirmed.
- Terminate the suspicious parent process and any child processes to stop ongoing clipboard harvesting activity.
- Conduct a forensic review of the clipboard history if available, and identify what sensitive data may have been exposed.
- Reset any credentials, API keys, or tokens that may have been present in the clipboard during the timeframe of the alert.
- Perform a full malware scan on the affected system using endpoint security tools to identify additional indicators of compromise.
- Review the origin of the parent script or application to understand the initial access vector and prevent reinfection.
- Escalate to the security operations team if the activity appears to be part of a coordinated campaign affecting multiple endpoints.


## Rule Query

```eql
process where host.os.type == "macos" and event.type == "start" and event.action == "exec" and
  process.name == "pbpaste" and process.args_count == 1 and
  (process.parent.name in ("node", "osascript") or process.parent.name like "python*") and
  not process.parent.executable like "/Users/*/.pyenv/versions/*/bin/python3*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Clipboard Data
- Id: T1115
- Reference URL: [[https://attack.mitre.org/techniques/T1115/](https://attack.mitre.org/techniques/T1115/)](https://attack.mitre.org/techniques/T1115/)