﻿---
title: Discovery Command Output Written to Suspicious File
description: Detects when a discovery command is executed followed by the immediate modification of a suspicious file via the same process. Many types of malware execute...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/collection_discovery_output_written_to_suspicious_file
products:
  - Elastic Security
---

# Discovery Command Output Written to Suspicious File
Detects when a discovery command is executed followed by the immediate modification of a suspicious file via
the same process. Many types of malware execute discovery commands, save the output to a file, and then
exfiltrate that file via their C2 channel.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*
- logs-endpoint.events.file-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: macOS
- Use Case: Threat Detection
- Tactic: Collection
- Tactic: Discovery
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Discovery Command Output Written to Suspicious File

This rule flags a macOS discovery utility launched from an interactive shell and, within seconds, the same process writing to an unusual or hidden file location, indicating staged reconnaissance for later theft. Adversaries commonly run commands like `whoami`, `ifconfig`, `dscl`, or `system_profiler` and redirect output into `/tmp`, `/Users/Shared`, or a dotfile path to bundle host details before exfiltrating the collected text.

### Possible investigation steps

- Review the created/modified file’s contents, size, and timestamps to confirm it contains discovery output and whether it is being appended across multiple executions.
- Pivot from the initiating process to identify subsequent child processes or shell commands that compress, encrypt, move, or delete the file, indicating staging and cleanup.
- Examine concurrent network activity from the same process tree for outbound connections, file uploads, or suspicious DNS/HTTP requests immediately after the write event.
- Validate the interactive session context by correlating to the logged-in user, terminal/TTY (if available), remote access artifacts (SSH/VPN/remote management), and recent authentication events for that account.
- Hunt on the host for related staging patterns such as additional hidden files in common drop locations, recent archive creation, or persistence changes (LaunchAgents/LaunchDaemons/crontab) around the alert time.


### False positive analysis

- An administrator or troubleshooting script run from bash/zsh may execute built-in discovery commands (e.g., `system_profiler`, `ifconfig`, `dscl`) and redirect the output into `/tmp`, `/private/tmp`, or `/Users/Shared` as a temporary log or support bundle artifact.
- A login/profile shell customization (e.g., `.zshrc`/`.bash_profile`) or local diagnostic routine may run `whoami`/`arch`/`csrutil` and append results into a hidden dotfile path (e.g., `/*/.*`) for auditing or environment validation, creating a short command-then-write pattern.


### Response and remediation

- Isolate the macOS host from the network and suspend or terminate the implicated shell/process tree that executed the discovery command and immediately wrote into locations like `/tmp`, `/Users/Shared`, or hidden dotfiles to prevent further staging or exfiltration.
- Quarantine the written file(s) and any adjacent artifacts (archives, encrypted blobs, renamed copies) from the same directories, preserve them for analysis, and remove the staged data once collection is complete.
- Identify and eradicate the launch point by reviewing the invoking shell history and user startup scripts (e.g., `.zshrc`, `.bash_profile`) for redirection or scripted discovery, and delete any associated persistence (LaunchAgents/LaunchDaemons, cron entries) tied to the same user or file path.
- Rotate credentials and invalidate active sessions for the logged-in user that ran the command, and audit recent remote access methods (SSH, remote management, VPN) used on the host to ensure the account was not compromised.
- Restore the host to a known-good state by reinstalling or reimaging if tampering is suspected, then monitor for re-creation of the same suspicious file paths and repeat discovery-to-file-write behavior from any interactive shell.
- Escalate to IR leadership immediately if the staged file contains host/user inventory data and there is evidence of outbound transfer attempts (new external connections, upload utilities like `curl`/`scp`, or rapid archive creation) following the write event.


## Rule Query

```eql
sequence by process.entity_id with maxspan=15s
  [process where host.os.type == "macos" and event.type == "start" and event.action == "exec" and
    process.parent.name in ("bash", "sh", "zsh") and
    process.name in ("whoami", "ifconfig", "system_profiler", "dscl", "arch", "csrutil") and
    process.args_count == 1]
  [file where host.os.type == "macos" and event.action == "modification" and
    file.path like ("/Users/Shared/*", "/tmp/*", "/private/tmp/*", "/Library/WebServer/*",
                    "/Library/Graphics/*", "/Library/Fonts/*", "/private/var/root/Library/HTTPStorages/*", "/*/.*") and
    not file.path like ("/private/tmp/*.fifo", "/private/tmp/tcl-tk*")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Data Staged
- Id: T1074
- Reference URL: [[https://attack.mitre.org/techniques/T1074/](https://attack.mitre.org/techniques/T1074/)](https://attack.mitre.org/techniques/T1074/)
- Sub Technique:
  - Name: Local Data Staging
- Id: T1074.001
- Reference URL: [[https://attack.mitre.org/techniques/T1074/001/](https://attack.mitre.org/techniques/T1074/001/)](https://attack.mitre.org/techniques/T1074/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)