﻿---
title: Potential Privilege Escalation through Writable Docker Socket
description: This rule monitors for the usage of Docker runtime sockets to escalate privileges on Linux systems. Docker sockets by default are only be writable by...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_writable_docker_socket
products:
  - Elastic Security
---

# Potential Privilege Escalation through Writable Docker Socket
This rule monitors for the usage of Docker runtime sockets to escalate privileges on Linux systems. Docker sockets by
default are only be writable by the root user and docker group. Attackers that have permissions to write to these
sockets may be able to create and run a container that allows them to escalate privileges and gain further access onto
the host file system.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://book.hacktricks.xyz/linux-hardening/privilege-escalation/docker-security/docker-breakout-privilege-escalation#automatic-enumeration-and-escape](https://book.hacktricks.xyz/linux-hardening/privilege-escalation/docker-security/docker-breakout-privilege-escalation#automatic-enumeration-and-escape)](https://book.hacktricks.xyz/linux-hardening/privilege-escalation/docker-security/docker-breakout-privilege-escalation#automatic-enumeration-and-escape)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Domain: Container
- Data Source: Elastic Defend
- Resources: Investigation Guide
- Data Source: Crowdstrike

**Version**: 10
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Privilege Escalation through Writable Docker Socket

Docker sockets facilitate communication between the Docker client and daemon, typically restricted to root or specific groups. Adversaries with write access can exploit these sockets to execute containers with elevated privileges, potentially accessing the host system. The detection rule identifies suspicious activities by monitoring processes like Docker and Socat for unauthorized socket interactions, focusing on non-root users attempting to execute commands, thus flagging potential privilege escalation attempts.

### Possible investigation steps

- Review the alert details to identify the specific process name (either "docker" or "socat") and the associated arguments that triggered the alert, focusing on the use of "unix://*/docker.sock" or "unix://*/dockershim.sock".
- Check the user and group IDs associated with the process to confirm they are non-root, as indicated by the exclusion of user.Ext.real.id and group.Ext.real.id being "0".
- Investigate the user account involved in the alert to determine if they should have access to Docker sockets and whether their permissions have been misconfigured or compromised.
- Examine the system logs and Docker daemon logs for any additional context or anomalies around the time of the alert to identify any unauthorized or suspicious activities.
- Assess the current state of the system for any unauthorized containers that may have been started, and inspect their configurations and running processes for signs of privilege escalation attempts.
- Verify the integrity and permissions of the Docker socket files to ensure they have not been altered to allow unauthorized access.


### False positive analysis

- Legitimate administrative tasks by non-root users with elevated permissions can trigger the rule. To manage this, identify trusted users or groups who regularly perform such tasks and create exceptions for their activities.
- Automated scripts or services that require Docker socket access for legitimate operations may be flagged. Review these scripts or services and whitelist their specific process names or arguments to prevent false positives.
- Development environments where developers frequently use Docker for testing might cause alerts. Consider creating a separate monitoring policy for development environments or exclude known development user accounts from this rule.
- Continuous integration/continuous deployment (CI/CD) pipelines that interact with Docker sockets can be mistakenly identified as threats. Ensure that these pipelines are running under specific service accounts and exclude these accounts from the rule.


### Response and remediation

- Immediately isolate the affected host from the network to prevent further unauthorized access or lateral movement.
- Terminate any unauthorized Docker containers that were started by non-root users, especially those interacting with Docker sockets.
- Review and revoke any unnecessary write permissions to Docker sockets for non-root users and groups, ensuring only trusted users have access.
- Conduct a thorough audit of user accounts and group memberships on the affected system to identify and remove any unauthorized or suspicious accounts.
- Restore the system from a known good backup if unauthorized changes or access to sensitive data are detected.
- Implement monitoring and alerting for any future unauthorized access attempts to Docker sockets, focusing on non-root user activities.
- Escalate the incident to the security operations team for further investigation and to assess potential impacts on other systems within the network.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action in ("exec", "ProcessRollup2") and
(
  (process.name == "docker" and process.args : "run" and process.args : "-it"  and
   process.args : ("unix://*/docker.sock", "unix://*/dockershim.sock")) or
  (process.name == "socat" and process.args : ("UNIX-CONNECT:*/docker.sock", "UNIX-CONNECT:*/dockershim.sock"))
) and not user.Ext.real.id : "0" and not group.Ext.real.id : "0"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Escape to Host
- Id: T1611
- Reference URL: [[https://attack.mitre.org/techniques/T1611/](https://attack.mitre.org/techniques/T1611/)](https://attack.mitre.org/techniques/T1611/)