﻿---
title: Namespace Manipulation Using Unshare
description: Identifies suspicious usage of unshare to manipulate system namespaces. Unshare can be utilized to escalate privileges or escape container security boundaries...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_unshare_namespace_manipulation
products:
  - Elastic Security
---

# Namespace Manipulation Using Unshare
Identifies suspicious usage of unshare to manipulate system namespaces. Unshare can be utilized to escalate privileges
or escape container security boundaries. Threat actors have utilized this binary to allow themselves to escape to the
host and access other resources or escalate privileges.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://man7.org/linux/man-pages/man1/unshare.1.html](https://man7.org/linux/man-pages/man1/unshare.1.html)](https://man7.org/linux/man-pages/man1/unshare.1.html)
- [[https://www.crowdstrike.com/blog/cve-2022-0185-kubernetes-container-escape-using-linux-kernel-exploit/](https://www.crowdstrike.com/blog/cve-2022-0185-kubernetes-container-escape-using-linux-kernel-exploit/)](https://www.crowdstrike.com/blog/cve-2022-0185-kubernetes-container-escape-using-linux-kernel-exploit/)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 114
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from one of the following integrations:
- Elastic Defend
- Auditbeat


### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


### Auditbeat Setup

Auditbeat is a lightweight shipper that you can install on your servers to audit the activities of users and processes on your systems. For example, you can use Auditbeat to collect and centralize audit events from the Linux Audit Framework. You can also use Auditbeat to detect changes to critical files, like binaries and configuration files, and identify potential security policy violations.

#### The following steps should be executed in order to add the Auditbeat on a Linux System:

- Elastic provides repositories available for APT and YUM-based distributions. Note that we provide binary packages, but no source packages.
- To install the APT and YUM repositories follow the setup instructions in this [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setup-repositories.html).
- To run Auditbeat on Docker follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-docker.html).
- To run Auditbeat on Kubernetes follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-kubernetes.html).
- For complete “Setup and Run Auditbeat” information refer to the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setting-up-and-running.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Namespace Manipulation Using Unshare

The `unshare` command in Linux is used to create new namespaces, isolating processes from the rest of the system. This isolation is crucial for containerization and security. However, attackers can exploit `unshare` to break out of containers or elevate privileges by creating namespaces that bypass security controls. The detection rule identifies suspicious `unshare` executions by monitoring process starts, filtering out benign parent processes, and focusing on unusual usage patterns, thus highlighting potential misuse.

### Possible investigation steps

- Review the process tree to understand the context of the unshare execution, focusing on the parent process and any child processes spawned by unshare.
- Investigate the user account associated with the unshare execution to determine if it is a legitimate user or potentially compromised.
- Examine the command-line arguments used with unshare to identify any unusual or suspicious options that may indicate an attempt to bypass security controls.
- Check for any recent changes or anomalies in the system logs around the time of the unshare execution to identify potential indicators of compromise or privilege escalation attempts.
- Correlate the unshare event with other security alerts or logs to determine if it is part of a larger attack pattern or campaign.


### False positive analysis

- System management tools like udevadm and systemd-udevd may invoke unshare as part of their normal operations. These should be excluded by ensuring the rule filters out processes with these as parent executables.
- Snap package management can trigger unshare during its operations. Exclude processes where the arguments include /usr/bin/snap to prevent unnecessary alerts.
- Java applications might occasionally use unshare for legitimate purposes. Exclude processes with java as the parent name to reduce false positives.
- Custom scripts or administrative tasks that use unshare for legitimate namespace management should be reviewed and, if deemed safe, added to the exclusion list to prevent repeated alerts.


### Response and remediation

- Immediately isolate the affected system to prevent further unauthorized access or lateral movement within the network.
- Terminate any suspicious processes associated with the `unshare` command that do not have legitimate parent processes or arguments, as identified in the detection query.
- Conduct a thorough review of system logs and process trees to identify any additional unauthorized or suspicious activities that may have occurred in conjunction with the `unshare` execution.
- Revoke any unauthorized access or privileges that may have been granted as a result of the namespace manipulation, ensuring that all user and process permissions are appropriately restricted.
- Restore the affected system from a known good backup if any unauthorized changes or damage to the system integrity are detected.
- Implement additional monitoring and alerting for unusual `unshare` usage patterns to enhance detection capabilities and prevent future occurrences.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems or data have been compromised.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action : ("exec", "exec_event", "start") and
process.executable: "/usr/bin/unshare" and not (
  process.parent.executable: ("/usr/bin/udevadm", "*/lib/systemd/systemd-udevd", "/usr/bin/unshare") or
  process.args == "/usr/bin/snap" and not process.parent.name in ("zz-proxmox-boot", "java") or
  process.parent.args like (
    "/etc/kernel/postinst.d/zz-proxmox-boot", "/opt/openssh/sbin/sshd", "/usr/sbin/sshd",
    "/snap/*", "/home/*/.local/share/JetBrains/Toolbox/*"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Create or Modify System Process
- Id: T1543
- Reference URL: [[https://attack.mitre.org/techniques/T1543/](https://attack.mitre.org/techniques/T1543/)](https://attack.mitre.org/techniques/T1543/)