﻿---
title: Privilege Escalation via CAP_SETUID/SETGID Capabilities
description: Identifies instances where a process (granted CAP_SETUID and/or CAP_SETGID capabilities) is executed, after which the user's access is elevated to UID/GID...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_suspicious_uid_guid_elevation
products:
  - Elastic Security
---

# Privilege Escalation via CAP_SETUID/SETGID Capabilities
Identifies instances where a process (granted CAP_SETUID and/or CAP_SETGID capabilities) is executed, after which the
user's access is elevated to UID/GID 0 (root). In Linux, the CAP_SETUID and CAP_SETGID capabilities allow a process to
change its UID and GID, respectively, providing control over user and group identity management. Attackers may leverage
a misconfiguration for exploitation in order to escalate their privileges to root.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 9
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Privilege Escalation via CAP_SETUID/SETGID Capabilities

In Linux, CAP_SETUID and CAP_SETGID capabilities allow processes to change user and group IDs, crucial for identity management. Adversaries exploit misconfigurations to gain root access. The detection rule identifies processes with these capabilities that elevate privileges to root, excluding benign scenarios, to flag potential misuse.

### Possible investigation steps

- Review the process details such as process.name and process.executable to identify the specific application or script that triggered the alert. This can help determine if the process is expected or potentially malicious.
- Examine the process.parent.executable and process.parent.name fields to understand the parent process that initiated the suspicious process. This can provide context on whether the parent process is legitimate or part of a known attack vector.
- Check the user.id field to confirm the user context under which the process was executed. If the user is not expected to have elevated privileges, this could indicate a potential compromise.
- Investigate the process.command_line to analyze the command executed. Look for any unusual or unexpected command patterns that could suggest malicious intent.
- Correlate the alert with other security events or logs from the same host.id to identify any related suspicious activities or patterns that could indicate a broader attack.
- Assess the environment for any recent changes or misconfigurations that could have inadvertently granted CAP_SETUID or CAP_SETGID capabilities to unauthorized processes.


### False positive analysis

- Processes related to system management tools like VMware, SolarWinds, and language tools may trigger false positives. Exclude these by adding their executables to the exception list.
- Scheduled tasks or system updates that involve processes like update-notifier or dbus-daemon can cause false alerts. Consider excluding these parent process names from the detection rule.
- Automation tools such as Ansible or scripts executed by Python may inadvertently match the rule. Exclude command lines that match known automation patterns.
- Legitimate use of sudo or pkexec for administrative tasks can be misinterpreted as privilege escalation. Exclude these executables if they are part of regular administrative operations.
- Monitoring tools like osqueryd or saposcol might trigger the rule during normal operations. Add these process names to the exception list to prevent unnecessary alerts.


### Response and remediation

- Immediately isolate the affected host from the network to prevent further unauthorized access or lateral movement by the adversary.
- Terminate any suspicious processes identified with CAP_SETUID or CAP_SETGID capabilities that have escalated privileges to root, ensuring no further exploitation occurs.
- Conduct a thorough review of the affected system's user and group configurations to identify and correct any misconfigurations that allowed the privilege escalation.
- Revoke unnecessary CAP_SETUID and CAP_SETGID capabilities from processes and users that do not require them, reducing the attack surface for future exploitation.
- Restore the affected system from a known good backup if unauthorized changes or persistent threats are detected, ensuring the system is returned to a secure state.
- Monitor the system and network for any signs of continued or attempted exploitation, using enhanced logging and alerting to detect similar threats in the future.
- Escalate the incident to the security operations team for further investigation and to assess the potential impact on other systems within the network.


## Rule Query

```eql
sequence by host.id, process.entity_id with maxspan=1s
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and process.name != null and
   (process.thread.capabilities.effective : "CAP_SET?ID" or process.thread.capabilities.permitted : "CAP_SET?ID") and
   user.id != "0" and not (
     process.parent.executable : ("/tmp/newroot/*", "/opt/carbonblack*") or
     process.parent.executable in (
       "/opt/SolarWinds/Agent/bin/Plugins/JobEngine/SolarWinds.Agent.JobEngine.Plugin", "/usr/bin/vmware-toolbox-cmd",
       "/usr/bin/dbus-daemon", "/usr/bin/update-notifier", "/usr/share/language-tools/language-options",
       "/opt/SolarWinds/Agent/*", "/usr/local/sbin/lynis.sh", "/usr/libexec/sssd/sssd_be",
       "/opt/sophos-spl/plugins/edr/bin/osqueryd.5", "/apps/dynatrace/oneagent/install/agent/lib64/oneagentos",
       "/opt/carbonblack/*/osqueryi"
     ) or
     process.executable : ("/opt/dynatrace/*", "/tmp/newroot/*", "/opt/SolarWinds/Agent/*") or
     process.executable in (
       "/bin/fgrep", "/usr/bin/sudo", "/usr/bin/pkexec", "/usr/lib/cockpit/cockpit-session", "/usr/sbin/suexec"
     ) or
     process.parent.name in ("update-notifier", "language-options", "osqueryd", "saposcol", "dbus-daemon", "osqueryi", "sdbrun") or
     process.command_line like ("sudo*BECOME-SUCCESS*", "/bin/sh*sapsysinfo.sh*", "sudo su", "sudo su -", "sudo -E -H bash -l") or
     process.name in ("sudo", "fgrep", "lsb_release", "apt-update", "dbus-daemon-launch-helper", "man") or
     process.parent.command_line like "/usr/bin/python*ansible*" or
     process.working_directory like ("/opt/Elastic/Agent/data/*", "/usr/sap/tmp") or
     process.args like ("/usr/bin/lsb_release*", "/bin/fgrep*")
   )]
  [process where host.os.type == "linux" and event.action == "uid_change" and event.type == "change" and
   (process.thread.capabilities.effective : "CAP_SET?ID" or process.thread.capabilities.permitted : "CAP_SET?ID")
   and user.id == "0"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)
- Technique:
  - Name: Abuse Elevation Control Mechanism
- Id: T1548
- Reference URL: [[https://attack.mitre.org/techniques/T1548/](https://attack.mitre.org/techniques/T1548/)](https://attack.mitre.org/techniques/T1548/)
- Sub Technique:
  - Name: Setuid and Setgid
- Id: T1548.001
- Reference URL: [[https://attack.mitre.org/techniques/T1548/001/](https://attack.mitre.org/techniques/T1548/001/)](https://attack.mitre.org/techniques/T1548/001/)