﻿---
title: Potential Sudo Privilege Escalation via CVE-2019-14287
description: This rule monitors for the execution of a suspicious sudo command that is leveraged in CVE-2019-14287 to escalate privileges to root. Sudo does not verify...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_sudo_cve_2019_14287
products:
  - Elastic Security
---

# Potential Sudo Privilege Escalation via CVE-2019-14287
This rule monitors for the execution of a suspicious sudo command that is leveraged in CVE-2019-14287 to escalate
privileges to root. Sudo does not verify the presence of the designated user ID and proceeds to execute using a user ID
that can be chosen arbitrarily. By using the sudo privileges, the command "sudo -u#-1" translates to an ID of 0,
representing the root user. This exploit may work for sudo versions prior to v1.28.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-auditd_manager.auditd-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.exploit-db.com/exploits/47502](https://www.exploit-db.com/exploits/47502)](https://www.exploit-db.com/exploits/47502)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Elastic Defend
- Use Case: Vulnerability
- Data Source: Elastic Endgame
- Data Source: Auditd Manager
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Sudo Privilege Escalation via CVE-2019-14287

CVE-2019-14287 exploits a flaw in certain sudo versions, allowing users to execute commands as root by bypassing user ID verification. Attackers can misuse this to gain unauthorized root access, posing significant security risks. The detection rule identifies suspicious sudo commands indicative of this exploit, focusing on specific command patterns that translate to root execution, thereby alerting security teams to potential privilege escalation attempts.

### Possible investigation steps

- Review the alert details to confirm the presence of the suspicious command pattern "sudo -u#-1" in the process arguments, as this is indicative of the CVE-2019-14287 exploit attempt.
- Identify the user account associated with the process execution to determine if the user should have legitimate access to execute commands with elevated privileges.
- Examine the process execution timeline to identify any preceding or subsequent suspicious activities that might indicate a broader attack or compromise.
- Check the version of sudo installed on the affected system to verify if it is vulnerable to CVE-2019-14287, specifically versions prior to v1.28.
- Investigate the source IP address and hostname of the affected system to assess if it is part of a larger attack pattern or if there are other systems potentially compromised.
- Review system logs and audit trails for any additional unauthorized access attempts or privilege escalation activities around the time of the alert.
- If possible, isolate the affected system to prevent further unauthorized access while conducting a more thorough forensic analysis.


### False positive analysis

- Legitimate administrative tasks using sudo with unconventional user ID arguments may trigger the rule. Review the context of the command execution to determine if it aligns with expected administrative activities.
- Automated scripts or maintenance tools that use sudo with arbitrary user IDs for testing or configuration purposes might be flagged. Identify and document these scripts, then create exceptions in the monitoring system to exclude them from alerts.
- Development environments where developers have elevated privileges for testing purposes could generate false positives. Ensure that such environments are well-documented and consider excluding them from this specific rule if they consistently trigger alerts.
- Security tools or monitoring systems that simulate attacks for testing detection capabilities may inadvertently trigger this rule. Coordinate with security teams to whitelist these tools or adjust their configurations to prevent unnecessary alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the attacker.
- Terminate any suspicious processes identified with the command pattern "sudo -u#-1" to halt any ongoing unauthorized activities.
- Conduct a thorough review of system logs and sudo logs to identify any additional unauthorized access attempts or successful privilege escalations.
- Reset passwords and review user accounts on the affected system to ensure no unauthorized accounts have been created or existing accounts have been compromised.
- Apply patches or upgrade sudo to a version later than v1.28 to mitigate the vulnerability exploited by CVE-2019-14287.
- Monitor the network for any signs of data exfiltration or further exploitation attempts, using enhanced logging and alerting mechanisms.
- Report the incident to the appropriate internal security team or external authorities if required, providing them with detailed findings and actions taken.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
  event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
  process.name == "sudo" and process.args == "-u#-1"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)