﻿---
title: Potential Privilege Escalation via SUID/SGID Proxy Execution
description: Detects potential privilege escalation via SUID/SGID proxy execution on Linux systems. Attackers may exploit binaries with the SUID/SGID bit set to execute...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_potential_suid_sgid_proxy_execution
products:
  - Elastic Security
---

# Potential Privilege Escalation via SUID/SGID Proxy Execution
Detects potential privilege escalation via SUID/SGID proxy execution on Linux systems. Attackers may exploit binaries with the
SUID/SGID bit set to execute commands with elevated privileges. This rule identifies instances where a process is executed with
root privileges (user ID 0 or group ID 0) while the real user or group ID is non-root, indicating potential misuse of SUID/SGID
binaries.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://dfir.ch/posts/today_i_learned_binfmt_misc/](https://dfir.ch/posts/today_i_learned_binfmt_misc/)](https://dfir.ch/posts/today_i_learned_binfmt_misc/)
- [[https://gtfobins.github.io/#+suid](https://gtfobins.github.io/#+suid)](https://gtfobins.github.io/#+suid)
- [[https://www.elastic.co/security-labs/primer-on-persistence-mechanisms](https://www.elastic.co/security-labs/primer-on-persistence-mechanisms)](https://www.elastic.co/security-labs/primer-on-persistence-mechanisms)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Tactic: Persistence
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Privilege Escalation via SUID/SGID Proxy Execution

This rule surfaces executions of well-known SUID/SGID helpers on Linux that run with root privileges while the launching user remains non‑root, signaling an attempt to proxy elevated rights. It matters because a non‑privileged process invoking pkexec can spawn /bin/sh as root via environment manipulation, turning a low-privilege foothold into full system control.

### Possible investigation steps

- Determine if the invocation is interactive and expected (e.g., admin using su/sudo) by correlating with a TTY/SSH session, recent successful authentication logs, and sudo/polkit policy outcomes in journald.
- For pkexec events, inspect the environment for exploit indicators (e.g., unset argv or suspicious GCONV_PATH, PATH, LD_PRELOAD, LC_* values) and look for attacker-created files in /tmp or the user's home that match gconv or loader artifacts.
- Review the child/descendant process tree of the SUID/SGID helper to see if it spawned a root shell or arbitrary interpreter, and pivot to concurrent network connections or file writes by those children.
- Validate whether the executable’s SUID/SGID file on disk has been tampered with by checking its hash, permissions, ownership, and recent mtime against package manager metadata and known-good baselines.
- If the binary is mount/umount/fusermount or newuidmap/newgidmap, correlate with container or FUSE activity to confirm a legitimate workflow and inspect mounts or namespace changes for risky options (e.g., suid, exec) or unusual target directories.


### False positive analysis

- An authorized pkexec or polkit-agent-helper invocation by a user to perform a permitted administrative task may run as root while the real user is non‑root, often with a single‑argument parent, and should align with an interactive prompt and expected policy.
- Normal unprivileged workflows using fusermount3 or newuidmap/newgidmap legitimately leverage SUID/SGID helpers, typically launched by a simple shell with one argument, and should correlate with expected mount or user‑namespace activity.


### Response and remediation

- Immediately isolate the host, kill the offending SUID/SGID child processes (e.g., pkexec spawning /bin/sh), and temporarily remove the setuid/setgid bit from the abused binary (chmod u-s /usr/bin/pkexec or chmod g-s /usr/bin/newgrp) to halt further elevation.
- Reinstall and verify integrity of abused packages and SUID helpers (e.g., polkit to replace /usr/bin/pkexec, dbus-daemon-launch-helper, fusermount3) and delete attacker artifacts such as gconv modules or LD_PRELOAD payloads from /tmp, /var/tmp, and user homes.
- Undo attacker changes by restoring /etc/sudoers, /etc/passwd and /etc/shadow, and polkit rules under /usr/share/polkit-1 or /etc/polkit-1, unmount suspicious FUSE or bind mounts created by fusermount3/mount, and rotate credentials and keys.
- Escalate to incident command if you observe a SUID helper launching an interactive root shell (/bin/sh -p or bash -p), root-owned droppers in /tmp or /usr/local/bin, or similar events on more than one host or account.
- Permanently reduce the SUID/SGID attack surface by auditing and removing setuid bits from rarely used binaries (e.g., chfn, chsh, newgrp, ssh-keysign), restricting pkexec via polkit rules to specific callers, and mounting /tmp, /var/tmp, and home directories with nosuid,nodev,noexec.
- Strengthen monitoring and policy by enabling AppArmor/SELinux confinement for pkexec and mount helpers, adding auditd rules for exec of setuid binaries and writes to /tmp by root, and enforcing least-privilege sudoers by removing broad NOPASSWD entries and requiring MFA for privileged tasks.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  (process.user.id == "0" and process.real_user.id != "0") or
  (process.group.id == "0" and process.real_group.id != "0")
) and process.args in (
  "/bin/su", "/usr/bin/su",
  "/usr/bin/sudo",
  "/bin/mount", "/usr/bin/mount",
  "/bin/umount", "/usr/bin/umount",
  "/usr/bin/fusermount3",
  "/bin/passwd", "/usr/bin/passwd",
  "/bin/chfn", "/usr/bin/chfn",
  "/bin/chsh", "/usr/bin/chsh",
  "/bin/gpasswd", "/usr/bin/gpasswd",
  "/bin/newgrp", "/usr/bin/newgrp",
  "/sbin/unix_chkpwd", "/usr/sbin/unix_chkpwd",
  "/usr/bin/newuidmap", "/usr/bin/newgidmap",
  "/usr/lib/dbus-1.0/dbus-daemon-launch-helper", "/usr/libexec/dbus-daemon-launch-helper",
  "/usr/lib/openssh/ssh-keysign", "/usr/libexec/openssh/ssh-keysign",
  "/usr/bin/pkexec", "/usr/libexec/pkexec", "/usr/lib/polkit-1/pkexec",
  "/usr/lib/polkit-1/polkit-agent-helper-1", "/usr/libexec/polkit-agent-helper-1",
  "/usr/lib/snapd/snap-confine"
) and process.parent.args_count == 1 and
not process.parent.executable in (
  "/usr/libexec/oracle-cloud-agent/plugins/unifiedmonitoring/unifiedmonitoring", "/usr/libexec/oracle-cloud-agent/agent",
  "/usr/lib/x86_64-linux-gnu/libexec/polkit-kde-authentication-agent-1", "/usr/libexec/xfce-polkit", "/usr/bin/dolphin"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)
- Technique:
  - Name: Abuse Elevation Control Mechanism
- Id: T1548
- Reference URL: [[https://attack.mitre.org/techniques/T1548/](https://attack.mitre.org/techniques/T1548/)](https://attack.mitre.org/techniques/T1548/)
- Sub Technique:
  - Name: Setuid and Setgid
- Id: T1548.001
- Reference URL: [[https://attack.mitre.org/techniques/T1548/001/](https://attack.mitre.org/techniques/T1548/001/)](https://attack.mitre.org/techniques/T1548/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)