﻿---
title: Potential Privilege Escalation via CVE-2023-4911
description: This rule detects potential privilege escalation attempts through Looney Tunables (CVE-2023-4911). Looney Tunables is a buffer overflow vulnerability...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_looney_tunables_cve_2023_4911
products:
  - Elastic Security
---

# Potential Privilege Escalation via CVE-2023-4911
This rule detects potential privilege escalation attempts through Looney Tunables (CVE-2023-4911). Looney Tunables is a
buffer overflow vulnerability in GNU C Library's dynamic loader's processing of the GLIBC_TUNABLES environment variable.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://blog.qualys.com/vulnerabilities-threat-research/2023/10/03/cve-2023-4911-looney-tunables-local-privilege-escalation-in-the-glibcs-ld-so](https://blog.qualys.com/vulnerabilities-threat-research/2023/10/03/cve-2023-4911-looney-tunables-local-privilege-escalation-in-the-glibcs-ld-so)](https://blog.qualys.com/vulnerabilities-threat-research/2023/10/03/cve-2023-4911-looney-tunables-local-privilege-escalation-in-the-glibcs-ld-so)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Use Case: Vulnerability
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 8
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).

Elastic Defend integration does not collect environment variable logging by default.
In order to capture this behavior, this rule requires a specific configuration option set within the advanced settings of the Elastic Defend integration.

#### To set up environment variable capture for an Elastic Agent policy:

- Go to “Security → Manage → Policies”.
- Select an “Elastic Agent policy”.
- Click “Show advanced settings”.
- Scroll down or search for “linux.advanced.capture_env_vars”.
- Enter the names of environment variables you want to capture, separated by commas.
- For this rule the linux.advanced.capture_env_vars variable should be set to "GLIBC_TUNABLES".
- Click “Save”.
  After saving the integration change, the Elastic Agents running this policy will be updated and the rule will function properly.
  For more information on capturing environment variables refer to the [helper guide](https://www.elastic.co/guide/en/security/current/environment-variable-capture.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Privilege Escalation via CVE-2023-4911

CVE-2023-4911 exploits a buffer overflow in the GNU C Library's dynamic loader, specifically targeting the GLIBC_TUNABLES environment variable. Adversaries can manipulate this to gain elevated privileges on Linux systems. The detection rule identifies suspicious activity by monitoring processes with specific environment variables, flagging repeated execution attempts within a short timeframe, indicating potential exploitation efforts.

### Possible investigation steps

- Review the alert details to identify the specific host.id and process.parent.entity_id associated with the suspicious activity.
- Examine the process.executable path to determine if it is a legitimate application or potentially malicious.
- Check the process.env_vars for any unusual or unexpected GLIBC_TUNABLES values that could indicate manipulation attempts.
- Investigate the host's recent process execution history to identify any patterns or anomalies, focusing on processes with the GLIBC_TUNABLES environment variable set.
- Correlate the alert with other security events or logs from the same host to identify any additional indicators of compromise or related suspicious activities.
- Assess the system for any signs of privilege escalation or unauthorized access, such as new user accounts or changes in user privileges.


### False positive analysis

- Frequent legitimate use of GLIBC_TUNABLES environment variable by system administrators or automated scripts can trigger false positives. Users should identify and whitelist these known benign processes to prevent unnecessary alerts.
- Some Linux distributions or specific applications may use GLIBC_TUNABLES for performance tuning or compatibility reasons. Review and document these cases, and create exceptions for these processes to avoid false alarms.
- Development environments where GLIBC_TUNABLES is used for testing purposes might also cause false positives. Implement a policy to exclude these environments from monitoring or adjust the rule to account for these specific use cases.
- Scheduled tasks or cron jobs that utilize GLIBC_TUNABLES for legitimate purposes can be mistaken for exploitation attempts. Ensure these tasks are recognized and excluded from the rule's scope to reduce noise.
- If a particular user or group frequently triggers the rule due to their role or activities, consider creating a user-based exception to minimize false positives while maintaining security oversight.


### Response and remediation

- Immediately isolate the affected Linux system from the network to prevent further exploitation or lateral movement by the adversary.
- Terminate any suspicious processes identified with the GLIBC_TUNABLES environment variable to halt ongoing exploitation attempts.
- Apply the latest security patches and updates to the GNU C Library on all affected systems to remediate the buffer overflow vulnerability.
- Conduct a thorough review of system logs and process execution history to identify any unauthorized changes or additional indicators of compromise.
- Restore affected systems from a known good backup taken before the exploitation attempt, ensuring that the backup is free from any malicious modifications.
- Implement enhanced monitoring and alerting for unusual process executions and environment variable manipulations to detect similar threats in the future.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to assess the potential impact on other systems within the network.


## Rule Query

```eql
sequence by host.id, process.parent.entity_id, process.executable with maxspan=5s
 [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
  process.env_vars : "*GLIBC_TUNABLES=glibc.*=glibc.*=*"] with runs=5
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)