﻿---
title: Kernel Load or Unload via Kexec Detected
description: This detection rule identifies the usage of kexec, helping to uncover unauthorized kernel replacements and potential compromise of the system's integrity...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_load_and_unload_of_kernel_via_kexec
products:
  - Elastic Security
---

# Kernel Load or Unload via Kexec Detected
This detection rule identifies the usage of kexec, helping to uncover unauthorized kernel replacements and potential
compromise of the system's integrity. Kexec is a Linux feature that enables the loading and execution of a different
kernel without going through the typical boot process. Malicious actors can abuse kexec to bypass security measures,
escalate privileges, establish persistence or hide their activities by loading a malicious kernel, enabling them to
tamper with the system's trusted state, allowing e.g. a VM Escape.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-auditd_manager.auditd-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.crowdstrike.com/blog/venom-vulnerability-details/](https://www.crowdstrike.com/blog/venom-vulnerability-details/)](https://www.crowdstrike.com/blog/venom-vulnerability-details/)
- [[https://www.makeuseof.com/what-is-venom-vulnerability/](https://www.makeuseof.com/what-is-venom-vulnerability/)](https://www.makeuseof.com/what-is-venom-vulnerability/)
- [[https://madaidans-insecurities.github.io/guides/linux-hardening.html](https://madaidans-insecurities.github.io/guides/linux-hardening.html)](https://madaidans-insecurities.github.io/guides/linux-hardening.html)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Privilege Escalation
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Auditd Manager
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 112
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kernel Load or Unload via Kexec Detected

Kexec is a Linux feature allowing a new kernel to load without rebooting, streamlining updates and recovery. However, attackers can exploit kexec to bypass security, escalate privileges, or hide activities by loading malicious kernels. The detection rule identifies suspicious kexec usage by monitoring process actions and arguments, excluding benign parent processes, to flag potential threats.

### Possible investigation steps

- Review the process details to confirm the presence of the kexec command with suspicious arguments such as "--exec", "-e", "--load", "-l", "--unload", or "-u".
- Investigate the parent process of the kexec command to ensure it is not a benign process like "kdumpctl" or "unload.sh", which are excluded from the detection rule.
- Check the user account associated with the kexec process to determine if it has the necessary privileges and if the activity aligns with their typical behavior.
- Analyze recent system logs and security events for any signs of privilege escalation or unauthorized kernel modifications around the time the kexec command was executed.
- Examine the system for any signs of persistence mechanisms or other indicators of compromise that may suggest a broader attack campaign.
- Correlate this event with other alerts or anomalies in the environment to assess if this is part of a larger attack pattern or isolated incident.


### False positive analysis

- Kdump operations may trigger false positives as kdumpctl is a benign parent process for kexec. Ensure kdumpctl is included in the exclusion list to prevent unnecessary alerts.
- Custom scripts for kernel unloading, such as unload.sh, can cause false positives. Verify these scripts are legitimate and add them to the exclusion list if they are frequently used in your environment.
- Routine administrative tasks involving kernel updates or testing may involve kexec. Confirm these activities are authorized and consider excluding specific administrative accounts or processes from detection.
- Automated system recovery processes that utilize kexec might be flagged. Identify these processes and exclude them if they are part of a known and secure recovery mechanism.
- Security tools or monitoring solutions that use kexec for legitimate purposes should be reviewed and excluded to avoid false alerts, ensuring they are recognized as trusted applications.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or potential lateral movement by the attacker.
- Terminate any suspicious kexec processes identified by the detection rule to halt any ongoing malicious kernel loading activities.
- Conduct a thorough review of system logs and process histories to identify any unauthorized kernel loads or modifications, and revert to a known good state if necessary.
- Restore the system from a clean backup taken before the suspicious activity was detected to ensure system integrity and remove any potential backdoors or malicious kernels.
- Update and patch the system to the latest security standards to mitigate any vulnerabilities that could be exploited by similar attacks in the future.
- Implement strict access controls and monitoring on systems with kexec capabilities to prevent unauthorized usage and ensure only trusted personnel can perform kernel operations.
- Escalate the incident to the security operations center (SOC) or relevant incident response team for further investigation and to assess the potential impact on other systems within the network.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
process.name == "kexec" and process.args in ("--exec", "-e", "--load", "-l", "--unload", "-u") and
not (
  process.parent.name in ("kdumpctl", "unload.sh") or
  process.parent.args in ("/usr/bin/kdumpctl", "/usr/sbin/kdump-config", "/usr/lib/kdump/unload.sh")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Escape to Host
- Id: T1611
- Reference URL: [[https://attack.mitre.org/techniques/T1611/](https://attack.mitre.org/techniques/T1611/)](https://attack.mitre.org/techniques/T1611/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Kernel Modules and Extensions
- Id: T1547.006
- Reference URL: [[https://attack.mitre.org/techniques/T1547/006/](https://attack.mitre.org/techniques/T1547/006/)](https://attack.mitre.org/techniques/T1547/006/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Modify System Image
- Id: T1601
- Reference URL: [[https://attack.mitre.org/techniques/T1601/](https://attack.mitre.org/techniques/T1601/)](https://attack.mitre.org/techniques/T1601/)
- Sub Technique:
  - Name: Patch System Image
- Id: T1601.001
- Reference URL: [[https://attack.mitre.org/techniques/T1601/001/](https://attack.mitre.org/techniques/T1601/001/)](https://attack.mitre.org/techniques/T1601/001/)