﻿---
title: Suspicious Kworker UID Elevation
description: Monitors for the elevation of regular user permissions to root permissions through the kworker process. kworker, or kernel worker, processes are part...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_kworker_uid_elevation
products:
  - Elastic Security
---

# Suspicious Kworker UID Elevation
Monitors for the elevation of regular user permissions to root permissions through the kworker process. kworker, or
kernel worker, processes are part of the kernel's workqueue mechanism. They are responsible for executing work that has
been scheduled to be done in kernel space, which might include tasks like handling interrupts, background activities,
and other kernel-related tasks. Attackers may attempt to evade detection by masquerading as a kernel worker process, and
hijack the execution flow by hooking certain functions/syscalls through a rootkit in order to provide easy access to
root via a special modified command.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Resources: Investigation Guide

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows
the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click Add integrations.
- In the query bar, search for Elastic Defend and select the integration to see more details about it.
- Click Add Elastic Defend.
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either Traditional Endpoints or Cloud Workloads.
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest to select "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in New agent policy name. If other agent policies already exist, you can click the Existing hosts tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click Save and Continue.
- To complete the integration, select Add Elastic Agent to your hosts and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Kworker UID Elevation

Kworker processes are integral to Linux, handling tasks like interrupts and background activities within the kernel. Adversaries may exploit these processes by disguising malicious activities as legitimate kernel operations, often using rootkits to hijack execution flow and gain root access. The detection rule identifies anomalies by monitoring for kworker processes that unexpectedly change session IDs and elevate privileges to root, signaling potential misuse.

### Possible investigation steps

- Review the process details for the kworker process with a session ID change and user ID of 0 to confirm the legitimacy of the process and its parent process.
- Check the system logs around the time of the session ID change event for any unusual activities or errors that might indicate tampering or exploitation attempts.
- Investigate any recent changes to the system, such as new software installations or updates, that could have introduced vulnerabilities or unauthorized modifications.
- Analyze the system for signs of rootkit presence, such as hidden files or processes, by using rootkit detection tools or manual inspection techniques.
- Correlate the event with other security alerts or anomalies in the network to determine if this is part of a broader attack campaign or isolated incident.


### False positive analysis

- Regular system updates or maintenance activities may trigger session ID changes in kworker processes. Users can monitor scheduled maintenance windows and exclude these time frames from triggering alerts.
- Custom kernel modules or legitimate software that interacts with kernel processes might cause kworker to change session IDs. Identify and whitelist these known modules or software to prevent false positives.
- Automated scripts or tools that require elevated privileges for legitimate tasks could inadvertently cause kworker processes to appear suspicious. Review and document these scripts, then create exceptions for their expected behavior.
- Certain system configurations or optimizations might lead to benign kworker session ID changes. Conduct a baseline analysis of normal system behavior and adjust the detection rule to accommodate these patterns without compromising security.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the attacker.
- Terminate the suspicious kworker process identified in the alert to stop any ongoing malicious activity.
- Conduct a thorough review of system logs and process trees to identify any additional compromised processes or indicators of rootkit installation.
- Restore the system from a known good backup if rootkit presence is confirmed, as rootkits can deeply embed themselves into the system.
- Change all credentials and keys that may have been exposed or used on the compromised system to prevent unauthorized access using stolen credentials.
- Implement enhanced monitoring and logging for kworker processes and session ID changes to detect similar activities in the future.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to assess the potential impact on other systems.


## Rule Query

```eql
process where host.os.type == "linux" and event.action == "session_id_change" and process.name : "kworker*" and
user.id == "0"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: KernelCallbackTable
- Id: T1574.013
- Reference URL: [[https://attack.mitre.org/techniques/T1574/013/](https://attack.mitre.org/techniques/T1574/013/)](https://attack.mitre.org/techniques/T1574/013/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Rootkit
- Id: T1014
- Reference URL: [[https://attack.mitre.org/techniques/T1014/](https://attack.mitre.org/techniques/T1014/)](https://attack.mitre.org/techniques/T1014/)