﻿---
title: File System Debugger Launched Inside a Container
description: This rule detects the use of the built-in Linux DebugFS utility from inside a container. DebugFS is a special file system debugging utility which supports...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_debugfs_launched_inside_container
products:
  - Elastic Security
---

# File System Debugger Launched Inside a Container
This rule detects the use of the built-in Linux DebugFS utility from inside a container. DebugFS is a special
file system debugging utility which supports reading and writing directly from a hard drive device. When launched inside
a privileged container, a container deployed with all the capabilities of the host machine, an attacker can access
sensitive host level files which could be used for further privilege escalation and container escapes to the host
machine.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://cyberark.wistia.com/medias/ygbzkzx93q?wvideo=ygbzkzx93q](https://cyberark.wistia.com/medias/ygbzkzx93q?wvideo=ygbzkzx93q)](https://cyberark.wistia.com/medias/ygbzkzx93q?wvideo=ygbzkzx93q)
- [[https://book.hacktricks.xyz/linux-hardening/privilege-escalation/docker-security/docker-breakout-privilege-escalation#privileged](https://book.hacktricks.xyz/linux-hardening/privilege-escalation/docker-security/docker-breakout-privilege-escalation#privileged)](https://book.hacktricks.xyz/linux-hardening/privilege-escalation/docker-security/docker-breakout-privilege-escalation#privileged)

**Tags**:
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.

For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating File System Debugger Launched Inside a Container

DebugFS is a Linux utility for direct file system manipulation, often used for debugging. In a privileged container, which has extensive access to the host, adversaries can exploit DebugFS to access sensitive host files, potentially leading to privilege escalation or container escape. The detection rule identifies suspicious DebugFS usage by monitoring process initiation with specific arguments in containers, flagging potential misuse.

### Possible investigation steps

- Review the alert details to confirm the process name is "debugfs" and check the specific arguments used, particularly looking for "/dev/sd*" to identify potential access to host file systems.
- Verify the container's security context to ensure it is indeed privileged, as this increases the risk of host-level access.
- Investigate the origin of the container image and deployment configuration to determine if the use of a privileged container was intentional or necessary.
- Check the user or service account that initiated the process to assess if it aligns with expected behavior or if it indicates potential unauthorized access.
- Examine recent logs and events from the container and host to identify any unusual activities or patterns that coincide with the alert.
- Assess the potential impact by identifying any sensitive files or directories that may have been accessed or modified by the debugfs process.


### False positive analysis

- Routine maintenance tasks using DebugFS in privileged containers can trigger alerts. To manage this, identify and document regular maintenance processes and create exceptions for these specific processes.
- Automated scripts or tools that utilize DebugFS for legitimate monitoring or debugging purposes may cause false positives. Review these scripts and whitelist them by excluding their specific process arguments or execution contexts.
- Development and testing environments often run privileged containers with DebugFS for debugging purposes. Establish a separate set of rules or exceptions for these environments to prevent unnecessary alerts.
- Backup or recovery operations that involve direct disk access might use DebugFS. Ensure these operations are well-documented and create exceptions based on their unique process signatures or execution schedules.


### Response and remediation

- Immediately isolate the affected container to prevent further access to sensitive host files. This can be done by stopping the container or removing its network access.
- Conduct a thorough review of the container's security context and capabilities to ensure it does not have unnecessary privileges. Adjust the container's configuration to remove privileged access if not required.
- Analyze the container's logs and process history to identify any unauthorized access or actions taken by the DebugFS utility. This will help determine the extent of the potential breach.
- If unauthorized access to host files is confirmed, perform a security assessment of the host system to identify any changes or breaches. This may include checking for new user accounts, modified files, or unexpected network connections.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems may be affected. Provide them with all relevant logs and findings.
- Implement additional monitoring and alerting for similar activities across other containers and hosts to detect any recurrence of this threat.
- Review and update container deployment policies to enforce the principle of least privilege, ensuring containers only have the necessary permissions to perform their intended functions.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
process.entry_leader.entry_meta.type == "container" and process.name == "debugfs" and
process.command_line like~ "/dev/sd*" and not process.args == "-R"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Escape to Host
- Id: T1611
- Reference URL: [[https://attack.mitre.org/techniques/T1611/](https://attack.mitre.org/techniques/T1611/)](https://attack.mitre.org/techniques/T1611/)