﻿---
title: Uncommon Destination Port Connection by Web Server
description: This rule identifies unusual destination port network activity originating from a web server process. The rule is designed to detect potential web shell...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_web_server_sus_destination_port
products:
  - Elastic Security
---

# Uncommon Destination Port Connection by Web Server
This rule identifies unusual destination port network activity originating from a web server process. The
rule is designed to detect potential web shell activity or unauthorized communication from a web server
process to external systems.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Execution
- Tactic: Command and Control
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Uncommon Destination Port Connection by Web Server

Web servers, crucial for hosting applications, typically communicate over standard ports like 80 and 443. Adversaries may exploit web server processes to establish unauthorized connections to unusual ports, potentially indicating web shell activity or data exfiltration. This detection rule identifies such anomalies by monitoring egress connections from web server processes to non-standard ports, excluding common local IP ranges, thus highlighting potential threats.

### Possible investigation steps

- Review the process name and user associated with the alert to determine if the connection attempt was made by a legitimate web server process or user, as specified in the query fields (e.g., process.name or user.name).
- Examine the destination IP address to assess whether it is known or suspicious, and check if it falls outside the excluded local IP ranges.
- Investigate the destination port to understand why the connection was attempted on a non-standard port, and determine if this port is associated with any known services or threats.
- Check historical logs for any previous connection attempts from the same process or user to the same or similar destination IPs and ports to identify patterns or repeated behavior.
- Analyze any related network traffic or logs to identify additional context or anomalies that may indicate unauthorized activity or data exfiltration.
- Correlate the alert with other security events or alerts to determine if it is part of a larger attack pattern or campaign.


### False positive analysis

- Routine administrative tasks or maintenance scripts may trigger alerts if they involve web server processes connecting to non-standard ports. To manage this, identify and document these tasks, then create exceptions for the specific processes and ports involved.
- Internal monitoring or management tools that use non-standard ports for legitimate purposes can cause false positives. Review the tools in use and exclude their known IP addresses and ports from the rule.
- Development or testing environments often use non-standard ports for web server processes. Ensure these environments are well-documented and consider excluding their IP ranges or specific ports from the rule.
- Load balancers or reverse proxies might redirect traffic to non-standard ports as part of their normal operation. Verify the configuration of these devices and exclude their IP addresses and ports if necessary.
- Custom applications running on web servers may require communication over non-standard ports. Work with application owners to understand these requirements and adjust the rule to exclude these specific cases.


### Response and remediation

- Immediately isolate the affected web server from the network to prevent further unauthorized access or data exfiltration.
- Conduct a thorough review of the web server's logs and processes to identify any unauthorized changes or suspicious activities, focusing on the processes and user accounts mentioned in the detection rule.
- Terminate any suspicious processes identified during the investigation that are not part of the standard operation of the web server.
- Change passwords and review permissions for the user accounts associated with the web server processes to ensure they have not been compromised.
- Restore the web server from a known good backup if any unauthorized changes or malware are detected, ensuring that the backup is free from compromise.
- Implement network segmentation to limit the web server's access to critical systems and data, reducing the potential impact of future incidents.
- Escalate the incident to the security operations team for further analysis and to determine if additional systems may be affected, ensuring comprehensive threat containment and remediation.


## Rule Query

```eql
network where host.os.type == "linux" and event.type == "start" and event.action == "connection_attempted" and (
  process.name like (
    "apache", "nginx", "apache2", "httpd", "lighttpd", "caddy", "mongrel_rails", "gunicorn",
    "uwsgi", "openresty", "cherokee", "h2o", "resin", "puma", "unicorn", "traefik", "tornado", "hypercorn",
    "daphne", "twistd", "yaws", "webfsd", "httpd.worker", "flask", "rails", "mongrel", "php-fpm*", "php-cgi",
    "php-fcgi", "php-cgi.cagefs", "catalina.sh", "hiawatha", "lswsctrl"
  ) or
  user.name in ("apache", "www-data", "httpd", "nginx", "lighttpd", "tomcat", "tomcat8", "tomcat9") or
  user.id in ("33", "498", "48") or
  (process.name == "java" and process.working_directory like "/u0?/*")
) and
network.direction == "egress" and destination.ip != null and
not destination.port in (80, 443, 8080, 8443, 8000, 8888, 3128, 3306, 5432, 8220, 8082) and
not cidrmatch(destination.ip, "127.0.0.0/8", "::1","FE80::/10", "FF00::/8", "10.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12", "192.0.0.0/24", "192.0.0.0/29", "192.0.0.8/32", "192.0.0.9/32",
"192.0.0.10/32", "192.0.0.170/32", "192.0.0.171/32", "192.0.2.0/24", "192.31.196.0/24", "192.52.193.0/24", "192.168.0.0/16", "192.88.99.0/24",
"224.0.0.0/4", "100.64.0.0/10", "192.175.48.0/24","198.18.0.0/15", "198.51.100.0/24", "203.0.113.0/24", "224.0.0.0/4", "240.0.0.0/4")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Server Software Component
- Id: T1505
- Reference URL: [[https://attack.mitre.org/techniques/T1505/](https://attack.mitre.org/techniques/T1505/)](https://attack.mitre.org/techniques/T1505/)
- Sub Technique:
  - Name: Web Shell
- Id: T1505.003
- Reference URL: [[https://attack.mitre.org/techniques/T1505/003/](https://attack.mitre.org/techniques/T1505/003/)](https://attack.mitre.org/techniques/T1505/003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)