﻿---
title: Unusual Process Spawned from Web Server Parent
description: This rule detects unusual processes spawned from a web server parent process by identifying low frequency counts of process spawning activity. Unusual...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_web_server_sus_child_spawned
products:
  - Elastic Security
---

# Unusual Process Spawned from Web Server Parent
This rule detects unusual processes spawned from a web server parent process by identifying low frequency counts of
process spawning activity. Unusual process spawning activity may indicate an attacker attempting to establish
persistence, execute malicious commands, or establish command and control channels on the host system. ESQL rules have
limited fields available in its alert documents. Make sure to review the original documents to aid in the investigation
of this alert.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 1h
**Searches indices from**: `now-61m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Execution
- Tactic: Command and Control
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 9
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Unusual Process Spawned from Web Server Parent

Web servers like Apache, Nginx, and others are crucial for hosting applications and services. Adversaries exploit these servers by spawning unauthorized processes to maintain persistence or execute malicious commands. The detection rule identifies anomalies by monitoring low-frequency process spawns from web server parents, focusing on unusual user IDs, directories, and process counts, which may indicate potential threats.

### Possible investigation steps

- Review the process.executable and process.command_line fields to understand the nature of the process that was spawned and assess if it aligns with expected behavior for the web server environment.
- Examine the process.working_directory to determine if the directory is a legitimate location for web server operations or if it appears suspicious, such as being outside typical web server directories.
- Check the user.name and user.id fields to verify if the process was executed by a legitimate web server user or if it was initiated by an unexpected or unauthorized user account.
- Investigate the process.parent.executable to confirm whether the parent process is a known and trusted web server executable or if it has been tampered with or replaced.
- Correlate the event with other logs or alerts from the same agent.id to identify any additional suspicious activities or patterns that may indicate a broader compromise.
- Assess the host.os.type to ensure the alert pertains to a Linux system, as specified in the query, and verify if there are any known vulnerabilities or misconfigurations on the host that could have been exploited.


### False positive analysis

- Processes related to legitimate web server maintenance tasks may trigger alerts. Review scheduled tasks or cron jobs that align with the alert timing and consider excluding these specific processes if they are verified as non-threatening.
- Development environments often spawn processes that mimic attack patterns. Identify and exclude processes originating from known development directories or executed by development user accounts.
- Automated scripts or monitoring tools running under web server user accounts can be mistaken for malicious activity. Verify these scripts and add exceptions for their specific process names or working directories.
- Frequent updates or deployments in web applications can lead to unusual process spawns. Document these activities and exclude related processes if they consistently match the alert criteria during known update windows.
- Custom web server modules or plugins may execute processes that appear suspicious. Validate these modules and exclude their associated processes if they are part of normal operations.


### Response and remediation

- Immediately isolate the affected host from the network to prevent further malicious activity and potential lateral movement.
- Terminate any suspicious processes identified by the alert that are not part of legitimate web server operations.
- Conduct a thorough review of the process command lines and executables flagged by the alert to identify any malicious scripts or binaries. Remove or quarantine these files as necessary.
- Check for unauthorized changes in web server configurations or files within the working directories flagged by the alert. Restore any altered files from a known good backup.
- Review user accounts and permissions associated with the web server processes to ensure no unauthorized accounts or privilege escalations have occurred. Reset passwords and revoke unnecessary access.
- Monitor network traffic from the affected host for any signs of command and control communication, and block any identified malicious IP addresses or domains.
- Escalate the incident to the security operations center (SOC) or incident response team for further analysis and to determine if additional systems are compromised.


## Rule Query

```esql
from logs-endpoint.events.process-* metadata _id, _index, _version
| mv_expand event.action
| where
    host.os.type == "linux" and
    event.type == "start" and
    event.action == "exec" and (
      (
        process.parent.name in (
            "apache", "nginx", "apache2", "httpd", "lighttpd", "caddy", "mongrel_rails", "gunicorn",
            "uwsgi", "openresty", "cherokee", "h2o", "resin", "puma", "unicorn", "traefik", "tornado", "hypercorn",
            "daphne", "twistd", "yaws", "webfsd", "httpd.worker", "flask", "rails", "mongrel", "php-cgi",
            "php-fcgi", "php-cgi.cagefs", "catalina.sh", "hiawatha", "lswsctrl"
        ) or
        process.parent.name like "php-fpm*" or
        user.name in ("apache", "www-data", "httpd", "nginx", "lighttpd", "tomcat", "tomcat8", "tomcat9") or
        user.id in ("33", "498", "48") or
        (process.parent.name == "java" and process.parent.working_directory like "/u0?/*") or
        process.parent.working_directory like "/var/www/*"
      )
    ) and (
        process.name in (
          "bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "socat", "openssl", "busybox",
          "nc", "ncat", "netcat", "nc.openbsd", "nc.traditional", "nohup", "setsid", "mkfifo", "mknod",
          "node", "socket"
        ) or
        process.name like "python*" or
        process.name like "php*" or
        process.name like "perl" or
        process.name like "ruby*" or
        process.name like "lua*" or
        process.executable like "/tmp/*" or
        process.executable like "/var/tmp/*" or
        process.executable like "/dev/shm/*" or
        process.executable like "/var/log/*" or
        process.executable like "/sys/*" or
        process.executable like "/media/*" or
        process.executable like "/proc/*" or
        process.executable like "/var/backups/*" or
        process.executable like "/var/mail/*" or
        process.executable like "/var/spool/*" or
        process.executable like "/var/www/*" or
        process.executable like "./*" or
        process.name like ".*"
    ) and    
    not (
        process.working_directory like "/home/*" or
        process.working_directory == "/" or
        process.working_directory like "/var/www/*.ch" or
        process.parent.executable like "/vscode/vscode-server/*"
    )

| keep
    @timestamp,
    _id,
    _index,
    _version,
    host.os.type,
    event.type,
    event.action,
    process.parent.name,
    user.name,
    user.id,
    process.working_directory,
    process.parent.working_directory,
    process.name,
    process.executable,
    process.command_line,
    process.parent.executable,
    agent.id,
    host.name,
    event.dataset,
    data_stream.namespace

| stats
    Esql.event_count = count(),
    Esql.agent_id_count_distinct = count_distinct(agent.id),
    Esql.host_name_values = values(host.name),
    Esql.agent_id_values = values(agent.id),
    Esql.event_dataset_values = values(event.dataset),
    Esql.data_stream_namespace_values = values(data_stream.namespace)

    by process.executable, process.working_directory, process.parent.executable

| where
    Esql.agent_id_count_distinct == 1 and
    Esql.event_count < 5
| sort Esql.event_count asc

// Extract unique values to ECS fields for alerts exclusion
| eval agent.id = mv_min(Esql.agent_id_values),
       host.name = mv_min(Esql.host_name_values)

| keep agent.id, host.name, process.executable, process.working_directory, process.parent.executable, Esql.*
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Server Software Component
- Id: T1505
- Reference URL: [[https://attack.mitre.org/techniques/T1505/](https://attack.mitre.org/techniques/T1505/)](https://attack.mitre.org/techniques/T1505/)
- Sub Technique:
  - Name: Web Shell
- Id: T1505.003
- Reference URL: [[https://attack.mitre.org/techniques/T1505/003/](https://attack.mitre.org/techniques/T1505/003/)](https://attack.mitre.org/techniques/T1505/003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)