﻿---
title: Linux User Account Credential Modification
description: This rule detects Linux user account credential modification events where the echo command is used to directly echo a password into the passwd or shadow...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_user_credential_modification_via_echo
products:
  - Elastic Security
---

# Linux User Account Credential Modification
This rule detects Linux user account credential modification events where the echo command is
used to directly echo a password into the passwd or shadow utilities. This technique is used by
malware to automate the process of user account credential modification on Linux systems post-infection.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Linux User Account Credential Modification

In Linux environments, user account credentials are crucial for system access and management. Adversaries may exploit command-line utilities to modify credentials, often using scripts to automate this process post-infection. The detection rule identifies suspicious use of shell commands that echo passwords into the passwd utility, a technique indicative of unauthorized credential changes, by monitoring specific command patterns and excluding benign processes.

### Possible investigation steps

- Review the process command line to confirm the presence of the suspicious pattern "*echo*passwd*" and assess if it aligns with known malicious activity.
- Identify the user account associated with the process to determine if it is a legitimate user or potentially compromised.
- Examine the parent process details, including the command line and executable path, to understand the context of how the suspicious process was initiated.
- Check for any recent changes to user accounts on the system, focusing on password modifications or new account creations around the time of the alert.
- Investigate the system for any additional signs of compromise, such as unexpected network connections or other suspicious processes running concurrently.
- Correlate the event with other security alerts or logs to identify if this activity is part of a broader attack pattern or campaign.


### False positive analysis

- Automated build processes may trigger this rule if they use shell scripts that include echoing passwords for testing or configuration purposes. To handle this, exclude processes with parent command lines or executables related to build tools like make.
- System administration scripts that automate user account management might use similar command patterns. Review these scripts and exclude them by specifying their parent process or executable paths.
- Custom user scripts for password management could inadvertently match the rule's criteria. Identify these scripts and add exceptions based on their unique command line or parent process attributes.
- Some legitimate software installations might use echo and passwd in their setup scripts. Monitor installation logs and exclude known safe installation processes by their parent command line or executable.


### Response and remediation

- Immediately isolate the affected Linux system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Terminate any suspicious processes identified by the detection rule, particularly those involving the echo command being used with the passwd utility.
- Change the passwords of any user accounts that may have been compromised, ensuring the use of strong, unique passwords.
- Review and audit recent user account changes and access logs to identify any unauthorized modifications or access attempts.
- Restore any affected user accounts to their previous state using backups or system snapshots, if available.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems are affected.
- Implement additional monitoring and alerting for similar command patterns to enhance detection and prevent recurrence of this threat.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish") and
process.command_line like (
  "*echo*> /etc/passwd*", "*echo*>/etc/passwd*",
  "*echo*> /etc/shadow*", "*echo*>/etc/shadow*"
) and
not (
  process.parent.command_line == "runc init" or
  process.parent.executable in ("/usr/bin/make", "/bin/make")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)