﻿---
title: Authentication via Unusual PAM Grantor
description: This rule detects successful authentications via PAM grantors that are not commonly used. This could indicate an attacker is attempting to escalate privileges...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_unusual_pam_grantor
products:
  - Elastic Security
---

# Authentication via Unusual PAM Grantor
This rule detects successful authentications via PAM grantors that are not commonly used. This could indicate an
attacker is attempting to escalate privileges or maintain persistence on the system by modifying the default PAM
configuration.
**Rule type**: new_terms
**Rule indices**:
- auditbeat-*
- logs-auditd_manager.auditd-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Persistence
- Data Source: Auditd Manager
- Resources: Investigation Guide

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires the use of the `auditd_manager` integration. `Auditd_manager` is a tool designed to simplify and enhance the management of the audit subsystem in Linux systems. It provides a user-friendly interface and automation capabilities for configuring and monitoring system auditing through the auditd daemon. With `auditd_manager`, administrators can easily define audit rules, track system events, and generate comprehensive audit reports, improving overall security and compliance in the system. The following steps should be executed in order to install and deploy `auditd_manager` on a Linux system.
```
Kibana -->
Management -->
Integrations -->
Auditd Manager -->
Add Auditd Manager
```

`Auditd_manager` subscribes to the kernel and receives events as they occur without any additional configuration. However, if more advanced configuration is required to detect specific behavior, audit rules can be added to the integration in either the "audit rules" configuration box or the "auditd rule files" box by specifying a file to read the audit rules from.
For this detection rule to trigger, no additional configuration is required.

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Authentication via Unusual PAM Grantor

Pluggable Authentication Modules (PAM) are integral to Linux systems, managing authentication tasks. Adversaries may exploit uncommon PAM grantors to escalate privileges or maintain persistence by altering default configurations. The detection rule identifies successful authentications using atypical PAM grantors, signaling potential unauthorized access or configuration tampering.

### Possible investigation steps

- Review the specific PAM grantor involved in the authentication event to determine if it is known or expected in your environment.
- Check the user account associated with the authentication event for any signs of compromise or unusual activity, such as recent changes in permissions or unexpected login times.
- Investigate the source IP address and hostname of the authentication event to verify if it is a recognized and authorized system within your network.
- Examine recent changes to the PAM configuration files on the affected host to identify any unauthorized modifications or additions.
- Correlate this event with other security alerts or logs from the same host or user to identify potential patterns of malicious activity.
- Consult with system administrators or relevant personnel to confirm if the use of the unusual PAM grantor was part of a legitimate change or update.


### False positive analysis

- Custom PAM modules: Organizations may use custom PAM modules for specific applications or security policies. Review these modules to ensure they are legitimate and add them to an exception list if they are frequently triggering alerts.
- Administrative scripts: Some administrative scripts might use non-standard PAM grantors for automation purposes. Verify the scripts' legitimacy and consider excluding them from the rule if they are part of routine operations.
- Third-party software: Certain third-party software may install or use uncommon PAM grantors as part of their authentication process. Validate the software's authenticity and add its grantors to an exception list if they are known to be safe.
- Development environments: In development or testing environments, developers might experiment with different PAM configurations. Ensure these environments are properly isolated and consider excluding them from the rule to avoid unnecessary alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Review the PAM configuration files on the affected system to identify and revert any unauthorized changes to the grantors. Ensure only legitimate PAM modules are in use.
- Terminate any suspicious or unauthorized processes that may have been initiated by the attacker to maintain persistence or escalate privileges.
- Conduct a thorough review of user accounts and privileges on the affected system to identify any unauthorized changes or newly created accounts. Revoke any unauthorized access.
- Restore the affected system from a known good backup if unauthorized changes cannot be easily reverted or if the system's integrity is in question.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement enhanced monitoring and logging for PAM-related activities across the network to detect similar threats in the future, ensuring that alerts are promptly reviewed and acted upon.


## Rule Query

```kuery
event.category:authentication and host.os.type:linux and event.action:authenticated and event.outcome:success and
auditd.data.grantors:(* and not (pam_rootok or *pam_cap* or *pam_permit*))
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create or Modify System Process
- Id: T1543
- Reference URL: [[https://attack.mitre.org/techniques/T1543/](https://attack.mitre.org/techniques/T1543/)](https://attack.mitre.org/techniques/T1543/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Modify Authentication Process
- Id: T1556
- Reference URL: [[https://attack.mitre.org/techniques/T1556/](https://attack.mitre.org/techniques/T1556/)](https://attack.mitre.org/techniques/T1556/)