﻿---
title: Shared Object Created by Previously Unknown Process
description: This rule monitors the creation of shared object files by previously unknown processes. The creation of a shared object file involves compiling code into...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_shared_object_creation
products:
  - Elastic Security
---

# Shared Object Created by Previously Unknown Process
This rule monitors the creation of shared object files by previously unknown processes. The creation of a shared object
file involves compiling code into a dynamically linked library that can be loaded by other programs at runtime. While
this process is typically used for legitimate purposes, malicious actors can leverage shared object files to execute
unauthorized code, inject malicious functionality into legitimate processes, or bypass security controls. This allows
malware to persist on the system, evade detection, and potentially compromise the integrity and confidentiality of the
affected system and its data.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.file*
- endgame-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://threatpost.com/sneaky-malware-backdoors-linux/180158/](https://threatpost.com/sneaky-malware-backdoors-linux/180158/)](https://threatpost.com/sneaky-malware-backdoors-linux/180158/)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 14
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis


### Investigating Shared Object Created by Previously Unknown Process

A shared object file is a compiled library file (typically with a .so extension) that can be dynamically linked to executable programs at runtime, allowing for code reuse and efficient memory usage. The creation of a shared object file involves compiling code into a dynamically linked library that can be loaded by other programs at runtime.
Malicious actors can leverage shared object files to execute unauthorized code, inject malicious functionality into legitimate processes, or bypass security controls. This allows malware to persist on the system, evade detection, and potentially compromise the integrity and confidentiality of the affected system and its data.
This rule monitors the creation of shared object files by previously unknown processes through the usage of the new terms rule type.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.
This investigation guide uses [placeholder fields](https://www.elastic.co/guide/en/security/current/osquery-placeholder-fields.html) to dynamically pass alert data into Osquery queries. Placeholder fields were introduced in Elastic Stack version 8.7.0. If you're using Elastic Stack version 8.6.0 or earlier, you'll need to manually adjust this investigation guide's queries to ensure they properly run.

#### Possible Investigation Steps

- Investigate the shared object that was created or modified through OSQuery.
  - $osquery_0
- $osquery_1
- Investigate the script execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence and whether they are located in expected locations.
  - $osquery_2
- Investigate other alerts associated with the user/host during the past 48 hours.
- Validate the activity is not related to planned patches, updates, network administrator activity, or legitimate software installations.
- Investigate whether the altered scripts call other malicious scripts elsewhere on the file system.
  - If scripts or executables were dropped, retrieve the files and determine if they are malicious:
  - Use a private sandboxed malware analysis system to perform analysis.
  - Observe and collect information about the following activities:
  - Attempts to contact external domains and addresses.
  - Check if the domain is newly registered or unexpected.
- Check the reputation of the domain or IP address.
- File access, modification, and creation activities.
- Cron jobs, services and other persistence mechanisms.
  - $osquery_3
- Investigate abnormal behaviors by the subject process/user such as network connections, file modifications, and any other spawned child processes.
  - Investigate listening ports and open sockets to look for potential command and control traffic or data exfiltration.
  - $osquery_4
- $osquery_5
- Identify the user account that performed the action, analyze it, and check whether it should perform this kind of action.
  - $osquery_6
- Investigate whether the user is currently logged in and active.
  - $osquery_7


### False Positive Analysis

- If this activity is related to new benign software installation activity, consider adding exceptions — preferably with a combination of user and command line conditions.
- If this activity is related to a system administrator that performed these actions for administrative purposes, consider adding exceptions for this specific administrator user account.
- Try to understand the context of the execution by thinking about the user, machine, or business purpose. A small number of endpoints, such as servers with unique software, might appear unusual but satisfy a specific business need.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Leverage the incident response data and logging to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
event.category:file and host.os.type:"linux" and event.action:("creation" or "file_create_event") and
(file.extension:"so" or file.name:*.so.*) and
file.path:(
  /dev/shm/* or /usr/lib/* or /usr/lib64/* or /usr/local/lib/* or /usr/local/lib64/* or /lib/x86_64-linux-gnu/* or
  /usr/lib/x86_64-linux-gnu/* or /lib/i386-linux-gnu/* or /usr/lib/i386-linux-gnu/* or /lib/* or /lib64/*
) and not (
  process.name:(
    "dockerd" or "dpkg" or "rpm" or "snapd" or "yum" or "vmis-launcher" or "pacman" or "apt-get" or "dnf" or "podman" or
    platform-python* or "dnf-automatic" or "unattended-upgrade" or "apk" or "snap-update-ns" or "install" or "exe" or
    "systemd" or "root" or "sshd" or "pip" or "jlink" or python* or "update-alternatives" or pip* or "crio" or "packagekitd"
  ) or 
  (process.name:"vmware-install.pl" and file.path:/usr/lib/vmware-tools/*) or
  (process.name:"ssm-agent-worker" and file.path:/usr/lib/jvm/java*) or 
  process.executable : (
    /dev/fd/* or "/" or "/kaniko/executor" or "/usr/bin/buildah" or "/usr/bin/microdnf" or "/usr/sbin/yum-cron" or
    "/usr/lib/check_mk_agent/plugins/3600/cmk-update-agent" or "/usr/bin/pamac-daemon" or "/usr/bin/dnf5" or
    "3600/cmk-update-agent" or "/usr/lib/dracut/dracut-install" or "/usr/bin/dockerd" or "/usr/sbin/crond" or
    "./usr/bin/qemu-aarch64-static" or "/usr/bin/nvidia-installer" or "./nvidia-installer" or "/usr/bin/cmake" or
    /var/lib/docker/overlay2/* or "/usr/sbin/gdm" or "/opt/ITSPlatform/plugin/scap/fortify-scap-plugin" or
    /tmp/makeself* or /tmp/selfgz* or "./usr/bin/qemu-aarch64" or "/usr/local/bin/cmake" or /opt/lpruitt/tmp/selfgz* or
    "/usr/lib/snapd/snap-update-ns" or "/sbin/yum-cron" or "/usr/local/psa/bin/dnf_install" or /opt/lmanteuffel/useful/tmp/makeself*
  ) or
  file.name:libnvidia*
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: Dynamic Linker Hijacking
- Id: T1574.006
- Reference URL: [[https://attack.mitre.org/techniques/T1574/006/](https://attack.mitre.org/techniques/T1574/006/)](https://attack.mitre.org/techniques/T1574/006/)