﻿---
title: Potential Backdoor Execution Through PAM_EXEC
description: This rule detects SSH session ID change followed by a suspicious SSHD child process, this may indicate the successful execution of a potentially malicious...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_pluggable_authentication_module_pam_exec_backdoor_exec
products:
  - Elastic Security
---

# Potential Backdoor Execution Through PAM_EXEC
This rule detects SSH session ID change followed by a suspicious SSHD child process, this may
indicate the successful execution of a potentially malicious process through the Pluggable
Authentication Module (PAM) utility. PAM is a framework used by Linux systems to authenticate
users. Adversaries may create malicious PAM modules that grant them persistence onto the
target every time a user logs in by executing a backdoor script or command.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/security-labs/approaching-the-summit-on-persistence](https://www.elastic.co/security-labs/approaching-the-summit-on-persistence)](https://www.elastic.co/security-labs/approaching-the-summit-on-persistence)
- [[https://www.group-ib.com/blog/pluggable-authentication-module/](https://www.group-ib.com/blog/pluggable-authentication-module/)](https://www.group-ib.com/blog/pluggable-authentication-module/)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Persistence
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Backdoor Execution Through PAM_EXEC

PAM (Pluggable Authentication Module) is a critical framework in Linux systems for user authentication. Adversaries may exploit PAM by inserting malicious modules that execute backdoor scripts during user logins, ensuring persistent access. The detection rule identifies this threat by monitoring SSH session changes followed by unusual child processes, often indicative of backdoor execution, especially when these processes originate from suspicious directories or use scripting languages.

### Possible investigation steps

- Review the process entity ID associated with the alert to identify the specific SSH session and its related activities.
- Examine the parent process details, specifically focusing on the SSH or SSHD process, to determine the source and legitimacy of the login attempt.
- Investigate the child process that was started, paying close attention to its name and executable path, especially if it matches patterns like scripting languages (e.g., perl, python) or suspicious directories (e.g., /tmp, /var/tmp).
- Check the process arguments count and content to understand the command or script being executed, which may provide insights into the potential backdoor's functionality.
- Correlate the event timestamp with user login records and system logs to identify any unusual login patterns or unauthorized access attempts.
- Assess the risk and impact by determining if the process has made any unauthorized changes to the system or if it has established any persistent mechanisms.
- If a backdoor is confirmed, initiate containment measures such as terminating the malicious process, removing the unauthorized PAM module, and conducting a full system audit to prevent further exploitation.


### False positive analysis

- Legitimate administrative scripts executed via SSH may trigger the rule if they use scripting languages like Perl, Python, or PHP. To handle this, identify and whitelist known administrative scripts and their execution paths.
- Automated backup or maintenance processes that run from directories like /var/backups or /var/log can be mistaken for malicious activity. Exclude these processes by specifying their exact paths and names in the exception list.
- Development or testing environments where scripts are frequently executed from temporary directories such as /tmp or /dev/shm may cause false positives. Implement exceptions for these environments by defining specific user accounts or process names that are known to be safe.
- Custom monitoring or logging tools that spawn child processes from SSH sessions might be flagged. Review these tools and add them to the exclusion list if they are verified as non-threatening.
- Regular user activities involving the use of scripting languages for legitimate purposes can be misinterpreted. Educate users on best practices and adjust the rule to exclude common benign scripts used in daily operations.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Terminate any suspicious processes identified by the detection rule, especially those originating from unusual directories or using scripting languages.
- Conduct a thorough review of PAM configuration files and modules to identify and remove any unauthorized or malicious entries.
- Reset credentials for all users on the affected system, prioritizing those with elevated privileges, to mitigate potential credential compromise.
- Restore the system from a known good backup if malicious modifications are confirmed, ensuring that the backup is free from tampering.
- Implement enhanced monitoring on the affected system and similar environments to detect any recurrence of the threat, focusing on SSH session changes and unusual child processes.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to assess the potential impact on other systems within the network.


## Rule Query

```eql
sequence by process.entity_id with maxspan=3s
  [process where host.os.type == "linux" and event.type == "change" and event.action == "session_id_change" and process.name in ("ssh", "sshd")]
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and process.parent.name in ("ssh", "sshd") and
   process.args_count == 2 and process.args like (
     "sh", "dash", "bash", "zsh",
     "perl*", "python*", "php*", "ruby*", "lua*",

     "/bin/sh", "/bin/dash", "/bin/bash", "/bin/zsh",
     "/bin/perl*", "/bin/python*", "/bin/php*", "/bin/ruby*", "/bin/lua*",

     "/usr/bin/sh", "/usr/bin/dash", "/usr/bin/bash", "/usr/bin/zsh",
     "/usr/bin/perl*", "/usr/bin/python*", "/usr/bin/php*", "/usr/bin/ruby*", "/usr/bin/lua*",

     "/usr/local/bin/sh", "/usr/local/bin/dash", "/usr/local/bin/bash", "/usr/local/bin/zsh",
     "/usr/local/bin/perl*", "/usr/local/bin/python*", "/usr/local/bin/php*", "/usr/local/bin/ruby*", "/usr/local/bin/lua*"
   ) and (
     process.name like ".*" or
     process.executable like (
       "/tmp/*", "/var/tmp/*", "/dev/shm/*", "./*", "/boot/*", "/sys/*", "/lost+found/*", "/media/*", "/proc/*", "/bin/*", "/usr/bin/*",
       "/sbin/*", "/usr/sbin/*", "/lib/*", "/lib64/*", "/usr/lib/*", "/usr/lib64/*", "/opt/*", "/var/lib/*", "/run/*", "/var/backups/*",
       "/var/log/*", "/var/mail/*", "/var/spool/*"
     )
   )
  ]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create or Modify System Process
- Id: T1543
- Reference URL: [[https://attack.mitre.org/techniques/T1543/](https://attack.mitre.org/techniques/T1543/)](https://attack.mitre.org/techniques/T1543/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Modify Authentication Process
- Id: T1556
- Reference URL: [[https://attack.mitre.org/techniques/T1556/](https://attack.mitre.org/techniques/T1556/)](https://attack.mitre.org/techniques/T1556/)