﻿---
title: Pluggable Authentication Module or Configuration Creation
description: This rule monitors for the creation of Pluggable Authentication Module (PAM) shared object files or configuration files. Attackers may create these files...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_pluggable_authentication_module_creation
products:
  - Elastic Security
---

# Pluggable Authentication Module or Configuration Creation
This rule monitors for the creation of Pluggable Authentication Module (PAM) shared object files or configuration
files. Attackers may create these files to maintain persistence on a compromised system, or harvest account credentials.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/zephrax/linux-pam-backdoor](https://github.com/zephrax/linux-pam-backdoor)](https://github.com/zephrax/linux-pam-backdoor)
- [[https://github.com/eurialo/pambd](https://github.com/eurialo/pambd)](https://github.com/eurialo/pambd)
- [http://0x90909090.blogspot.com/2016/06/creating-backdoor-in-pam-in-5-line-of.html](http://0x90909090.blogspot.com/2016/06/creating-backdoor-in-pam-in-5-line-of.html)
- [[https://www.trendmicro.com/en_us/research/19/i/skidmap-linux-malware-uses-rootkit-capabilities-to-hide-cryptocurrency-mining-payload.html](https://www.trendmicro.com/en_us/research/19/i/skidmap-linux-malware-uses-rootkit-capabilities-to-hide-cryptocurrency-mining-payload.html)](https://www.trendmicro.com/en_us/research/19/i/skidmap-linux-malware-uses-rootkit-capabilities-to-hide-cryptocurrency-mining-payload.html)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Persistence
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 8
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Pluggable Authentication Module or Configuration Creation

Pluggable Authentication Modules (PAM) are integral to Linux systems, managing authentication tasks. Adversaries may exploit PAM by creating or altering its modules or configurations to gain persistence or capture credentials. The detection rule identifies suspicious activities by monitoring file operations in PAM directories, excluding legitimate processes, thus highlighting potential unauthorized modifications.

### Possible investigation steps

- Review the file path and extension to determine if the modified or created file is a PAM shared object or configuration file, focusing on paths like "/lib/security/*", "/etc/pam.d/*", and "/etc/security/pam_*".
- Identify the process executable responsible for the file operation and verify if it is listed as an excluded legitimate process, such as "/bin/dpkg" or "/usr/bin/yum". If not, investigate the process further.
- Check the process execution history and command line arguments to understand the context of the file operation and assess if it aligns with typical system administration tasks.
- Investigate the user account associated with the process to determine if it has legitimate access and permissions to modify PAM files, and check for any signs of compromise or misuse.
- Examine recent system logs and security alerts for any related suspicious activities or anomalies that might indicate a broader attack or compromise.
- If the file operation is deemed suspicious, consider restoring the original PAM configuration from a known good backup and monitor the system for any further unauthorized changes.


### False positive analysis

- Package management operations: Legitimate package managers like dpkg, rpm, and yum may trigger the rule during software updates or installations. To handle this, exclude these processes by adding them to the exception list in the rule configuration.
- System updates and maintenance: Processes such as pam-auth-update and systemd may modify PAM configurations during routine system updates. Exclude these processes to prevent false positives.
- Temporary files: Files with extensions like swp, swpx, and swx are often temporary and not indicative of malicious activity. Exclude these extensions to reduce noise.
- Development environments: Paths like /nix/store/* and /snap/* may be used in development or containerized environments. Consider excluding these paths if they are part of a known and secure setup.
- Automated scripts: Scripts using tools like sed or perl may create temporary files that match the rule's criteria. Exclude these specific patterns if they are part of regular, non-malicious operations.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Review the specific PAM module or configuration file that was created or modified to understand the changes made and assess the potential impact on system security.
- Restore the affected PAM files from a known good backup to ensure the integrity of the authentication process and remove any malicious modifications.
- Conduct a thorough scan of the system using updated antivirus and anti-malware tools to identify and remove any additional malicious software that may have been introduced.
- Monitor the system and network for any signs of continued unauthorized access or suspicious activity, focusing on the indicators of compromise related to PAM manipulation.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if other systems may be affected.
- Implement additional monitoring and alerting for PAM-related activities to enhance detection capabilities and prevent similar threats in the future.


## Rule Query

```eql
file where host.os.type == "linux" and event.action == "creation" and process.executable != null and (
  (file.path like (
    "/lib/security/*", "/lib64/security/*", "/usr/lib/security/*", "/usr/lib64/security/*",
    "/lib/x86_64-linux-gnu/security/*", "/usr/lib/x86_64-linux-gnu/security/*"
  ) and file.extension == "so") or
  (file.path like "/etc/pam.d/*" and file.extension == null) or
  (file.path like "/etc/security/pam_*" or file.path == "/etc/pam.conf")
) and not (
  process.executable in (
    "/bin/dpkg", "/usr/bin/dpkg", "/bin/dockerd", "/usr/bin/dockerd", "/usr/sbin/dockerd", "/bin/microdnf",
    "/usr/bin/microdnf", "/bin/rpm", "/usr/bin/rpm", "/bin/snapd", "/usr/bin/snapd", "/bin/yum", "/usr/bin/yum",
    "/bin/dnf", "/usr/bin/dnf", "/bin/podman", "/usr/bin/podman", "/bin/dnf-automatic", "/usr/bin/dnf-automatic",
    "/bin/pacman", "/usr/bin/pacman", "/usr/bin/dpkg-divert", "/bin/dpkg-divert", "/sbin/apk", "/usr/sbin/apk",
    "/usr/local/sbin/apk", "/usr/bin/apt", "/usr/sbin/pacman", "/bin/podman", "/usr/bin/podman", "/usr/bin/puppet",
    "/bin/puppet", "/opt/puppetlabs/puppet/bin/puppet", "/usr/bin/chef-client", "/bin/chef-client",
    "/bin/autossl_check", "/usr/bin/autossl_check", "/proc/self/exe", "/usr/bin/pamac-daemon",
    "/bin/pamac-daemon", "/usr/lib/snapd/snapd", "/usr/local/bin/dockerd", "/usr/sbin/pam-auth-update",
    "/usr/lib/systemd/systemd", "/usr/libexec/packagekitd", "/usr/bin/bsdtar", "/sbin/pam-auth-update", "./user/bin/podman",
    "/usr/bin/dnf5", "/opt/puppetlabs/puppet/bin/ruby", "/usr/bin/crio", "/sbin/authconfig", "/usr/sbin/yum-cron",
    "/sbin/yum-cron", "/usr/local/psa/bin/dnf_install", "/opt/jc/bin/jumpcloud-agent", "./usr/bin/podman",
    "/kaniko/executor", "/opt/kaniko/executor", "/usr/bin/buildah", "/usr/sbin/pam-config",
    "./usr/lib/snapd/snap-update-ns", "/usr/bin/install", "/usr/bin/env"
  ) or
  file.path like (
    "/tmp/snap.rootfs_*/pam_*.so", "/tmp/newroot/lib/*/pam_*.so", "/tmp/newroot/usr/lib64/security/pam_*.so"
  ) or
  file.extension in ("swp", "swpx", "swx", "dpkg-remove") or
  file.Ext.original.extension == "dpkg-new" or
  file.Ext.original.name like "*.pam-new" or
  process.executable like (
    "/nix/store/*", "/var/lib/dpkg/*", "/snap/*", "/dev/fd/*", "/usr/lib/virtualbox/*", "/usr/bin/python*",
    "/opt/alt/python*/bin/python*", "/usr/libexec/platform-python*", "./snap/snapd/*/usr/lib/snapd/snap-update-ns"
  ) or
  (process.name == "sed" and file.name like~ "sed*") or
  (process.name == "perl" and file.name like~ "e2scrub_all.tmp*") or
  (process.name == "perl" and event.action == "rename" and file.Ext.original.name like "*.pam-new") or
  process.name like ("python*", "platform-python*", "dockerd") or
  (process.name == "vim.basic" and file.name like "*~")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create or Modify System Process
- Id: T1543
- Reference URL: [[https://attack.mitre.org/techniques/T1543/](https://attack.mitre.org/techniques/T1543/)](https://attack.mitre.org/techniques/T1543/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Modify Authentication Process
- Id: T1556
- Reference URL: [[https://attack.mitre.org/techniques/T1556/](https://attack.mitre.org/techniques/T1556/)](https://attack.mitre.org/techniques/T1556/)