﻿---
title: Loadable Kernel Module Configuration File Creation
description: This rule detects the creation of Loadable Kernel Module (LKM) configuration files. Attackers may create or modify these files to allow their LKMs to...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_lkm_configuration_file_creation
products:
  - Elastic Security
---

# Loadable Kernel Module Configuration File Creation
This rule detects the creation of Loadable Kernel Module (LKM) configuration files. Attackers may create or modify these
files to allow their LKMs to be loaded upon reboot, ensuring persistence on a compromised system.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Loadable Kernel Module Configuration File Creation

Loadable Kernel Modules (LKMs) are components that can be dynamically loaded into the Linux kernel to extend its functionality without rebooting. Adversaries exploit this by creating or altering LKM configuration files to ensure their malicious modules load at startup, achieving persistence. The detection rule identifies suspicious file creation or renaming activities in key directories, excluding benign processes, to flag potential threats.

### Possible investigation steps

- Review the file path and name to determine if it matches any known or expected LKM configuration files, focusing on paths like /etc/modules, /etc/modprobe.d/*, and others specified in the query.
- Examine the process executable responsible for the file creation or renaming to identify if it is a known or trusted application, especially if it is not in the list of excluded executables.
- Check the process name and executable path for any anomalies or signs of masquerading, particularly if they are not in the list of excluded names or paths.
- Investigate the user account associated with the process to determine if it has legitimate access or if it might be compromised.
- Correlate the event with other recent system activities to identify any patterns or additional suspicious behavior, such as other file modifications or network connections.
- Review system logs for any related entries that might provide additional context or evidence of malicious activity.
- Assess the risk and impact of the detected activity on the system's security posture and determine if further containment or remediation actions are necessary.


### False positive analysis

- System package managers like dpkg, rpm, and yum may trigger false positives when they update or install legitimate kernel modules. To handle this, exclude these processes by adding them to the exception list in the detection rule.
- Automated system management tools such as Puppet, Chef, and Ansible can create or modify LKM configuration files during routine operations. Exclude these processes by specifying their executables in the exception criteria.
- Temporary files created by text editors or system processes, such as those with extensions like swp or swx, can be mistaken for suspicious activity. Exclude these file extensions to reduce false positives.
- Processes running from specific directories like /nix/store or /snap may be part of legitimate software installations. Add these paths to the exclusion list to prevent unnecessary alerts.
- Scheduled tasks or cron jobs that involve file operations in the monitored directories might be flagged. Identify and exclude these processes by their names or paths to minimize false positives.


### Response and remediation

- Isolate the affected system from the network to prevent further propagation of the malicious loadable kernel module.
- Terminate any suspicious processes identified in the alert that are associated with the creation or modification of LKM configuration files.
- Remove or revert any unauthorized changes to LKM configuration files in the specified directories to prevent the malicious module from loading on reboot.
- Conduct a thorough scan of the system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any additional malicious components.
- Review system logs and the history of executed commands to identify the initial vector of compromise and any other affected systems.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are compromised.
- Implement additional monitoring and alerting for similar suspicious activities to enhance detection and response capabilities for future incidents.


## Rule Query

```eql
file where host.os.type == "linux" and event.action == "creation" and process.executable != null and
file.path like (
  "/etc/modules", "/etc/modprobe.d/*", "/run/modprobe.d/*", "/usr/local/lib/modprobe.d/*", "/usr/lib/modprobe.d/*",
  "/lib/modprobe.d/*", "/etc/modules-load.d/*", "/run/modules-load.d/*", "/usr/local/lib/modules-load.d/*",
  "/usr/lib/modules-load.d/*"
) and not (
  process.executable in (
    "/bin/dpkg", "/usr/bin/dpkg", "/bin/dockerd", "/usr/bin/dockerd", "/usr/sbin/dockerd", "/bin/microdnf",
    "/usr/bin/microdnf", "/bin/rpm", "/usr/bin/rpm", "/bin/snapd", "/usr/bin/snapd", "/bin/yum", "/usr/bin/yum",
    "/bin/dnf", "/usr/bin/dnf", "/bin/podman", "/usr/bin/podman", "/bin/dnf-automatic", "/usr/bin/dnf-automatic",
    "/bin/pacman", "/usr/bin/pacman", "/usr/bin/dpkg-divert", "/bin/dpkg-divert", "/sbin/apk", "/usr/sbin/apk",
    "/usr/local/sbin/apk", "/usr/bin/apt", "/usr/sbin/pacman", "/bin/podman", "/usr/bin/podman", "/usr/bin/puppet",
    "/bin/puppet", "/opt/puppetlabs/puppet/bin/puppet", "/usr/bin/chef-client", "/bin/chef-client",
    "/bin/autossl_check", "/usr/bin/autossl_check", "/proc/self/exe", "/dev/fd/*",  "/usr/bin/pamac-daemon",
    "/bin/pamac-daemon", "/usr/local/bin/dockerd", "/opt/elasticbeanstalk/bin/platform-engine",
    "/opt/puppetlabs/puppet/bin/ruby", "/usr/libexec/platform-python", "/opt/imunify360/venv/bin/python3",
    "/opt/eset/efs/lib/utild", "/usr/sbin/anacron", "/usr/bin/podman", "/kaniko/kaniko-executor", "/usr/bin/prime-select",
    "/usr/lib/dracut/dracut-install", "/usr/bin/dnf5", "./usr/bin/podman", "/usr/libexec/packagekitd", "/usr/bin/buildah",
    "./usr/lib/snapd/snap-update-ns", "/usr/lib/snapd/snapd", "/usr/local/bin/podman", "/usr/sbin/yum-cron",
    "./usr/bin/qemu-aarch64-static", "/.envbuilder/bin/envbuilder"
  ) or
  file.extension in ("swp", "swpx", "swx", "dpkg-remove") or
  file.Ext.original.extension == "dpkg-new" or
  process.executable like (
    "/nix/store/*", "/var/lib/dpkg/info/kmod.postinst", "/tmp/vmis.*", "/snap/*", "/dev/fd/*",
    "/usr/libexec/platform-python*", "./snap/snapd/*/snap-update-ns"
  ) or
  process.executable == null or
  process.name in (
    "crond", "executor", "puppet", "droplet-agent.postinst", "cf-agent", "schedd", "imunify-notifier", "perl",
    "jumpcloud-agent", "crio", "dnf_install", "utild", "dockerd"
  ) or
  process.name like "python*" or
  (process.name == "sed" and file.name : "sed*") or
  (process.name == "perl" and file.name : "e2scrub_all.tmp*")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Kernel Modules and Extensions
- Id: T1547.006
- Reference URL: [[https://attack.mitre.org/techniques/T1547/006/](https://attack.mitre.org/techniques/T1547/006/)](https://attack.mitre.org/techniques/T1547/006/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Rootkit
- Id: T1014
- Reference URL: [[https://attack.mitre.org/techniques/T1014/](https://attack.mitre.org/techniques/T1014/)](https://attack.mitre.org/techniques/T1014/)